/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.events.email;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.email.EmailProvider;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerProviderFactory;
import org.keycloak.events.EventType;
import org.keycloak.events.email.EmailEventListenerProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class EmailEventListenerProviderFactory
implements EventListenerProviderFactory {
    private static final Set<EventType> SUPPORTED_EVENTS = new HashSet<EventType>();
    private Set<EventType> includedEvents = new HashSet<EventType>();

    public EventListenerProvider create(KeycloakSession session) {
        EmailProvider emailProvider = (EmailProvider)session.getProvider(EmailProvider.class);
        return new EmailEventListenerProvider(session, emailProvider, this.includedEvents);
    }

    public void init(Config.Scope config) {
        String[] include = config.getArray("include-events");
        if (include != null) {
            for (String i : include) {
                this.includedEvents.add(EventType.valueOf((String)i.toUpperCase()));
            }
        } else {
            this.includedEvents.addAll(SUPPORTED_EVENTS);
        }
        String[] exclude = config.getArray("exclude-events");
        if (exclude != null) {
            for (String e : exclude) {
                this.includedEvents.remove(EventType.valueOf((String)e.toUpperCase()));
            }
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "email";
    }

    static {
        Collections.addAll(SUPPORTED_EVENTS, EventType.LOGIN_ERROR, EventType.UPDATE_PASSWORD, EventType.REMOVE_TOTP, EventType.UPDATE_TOTP);
    }
}

