/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.api.rest.impl;

import io.apiman.gateway.api.rest.contract.IApplicationResource;
import io.apiman.gateway.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.gateway.api.rest.impl.AbstractResourceImpl;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.exceptions.AbstractEngineException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;

public class ApplicationResourceImpl
extends AbstractResourceImpl
implements IApplicationResource {
    public void register(Application application) throws RegistrationException, NotAuthorizedException {
        final HashSet errorHolder = new HashSet();
        final CountDownLatch latch = new CountDownLatch(1);
        this.getEngine().getRegistry().registerApplication(application, (IAsyncResultHandler)new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isError()) {
                    errorHolder.add(result.getError());
                }
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (!errorHolder.isEmpty()) {
            Throwable error = (Throwable)errorHolder.iterator().next();
            if (error instanceof AbstractEngineException) {
                throw (AbstractEngineException)error;
            }
            throw new RuntimeException(error);
        }
    }

    public void unregister(String organizationId, String applicationId, String version) throws RegistrationException, NotAuthorizedException {
        final HashSet errorHolder = new HashSet();
        final CountDownLatch latch = new CountDownLatch(1);
        Application application = new Application();
        application.setOrganizationId(organizationId);
        application.setApplicationId(applicationId);
        application.setVersion(version);
        this.getEngine().getRegistry().unregisterApplication(application, (IAsyncResultHandler)new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isError()) {
                    errorHolder.add(result.getError());
                }
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (!errorHolder.isEmpty()) {
            Throwable error = (Throwable)errorHolder.iterator().next();
            if (error instanceof AbstractEngineException) {
                throw (AbstractEngineException)error;
            }
            throw new RuntimeException(error);
        }
    }
}

