/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class ESClientFactory {
    private static Map<String, Client> clients = new HashMap<String, Client>();

    public static void clearClientCache() {
        clients.clear();
    }

    public static Client createClient(Map<String, String> config) {
        Client client = null;
        String clientType = config.get("client.type");
        if ("local".equals(clientType)) {
            client = ESClientFactory.createLocalClient(config);
        } else if ("transport".equals(clientType)) {
            client = ESClientFactory.createTransportClient(config);
        } else {
            throw new RuntimeException("Invalid elasticsearch client type: " + clientType);
        }
        return client;
    }

    public static Client createTransportClient(Map<String, String> config) {
        String clusterName = config.get("client.cluster-name");
        String host = config.get("client.host");
        String port = config.get("client.port");
        if (StringUtils.isBlank((String)clusterName)) {
            throw new RuntimeException("Missing client.cluster-name configuration for ESRegistry.");
        }
        if (StringUtils.isBlank((String)host)) {
            throw new RuntimeException("Missing client.host configuration for ESRegistry.");
        }
        if (StringUtils.isBlank((String)port)) {
            throw new RuntimeException("Missing client.port configuration for ESRegistry.");
        }
        return ESClientFactory.createTransportClient(host, Integer.parseInt(port), clusterName);
    }

    public static Client createLocalClient(Map<String, String> config) {
        String clientLocClassName = config.get("client.class");
        String clientLocFieldName = config.get("client.field");
        return ESClientFactory.createLocalClient(clientLocClassName, clientLocFieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Client createTransportClient(String host, int port, String clusterName) {
        String clientKey = "transport:" + host + ':' + port + '/' + clusterName;
        Map<String, Client> map = clients;
        synchronized (map) {
            if (clients.containsKey(clientKey)) {
                return clients.get(clientKey);
            }
            TransportClient client = new TransportClient(ImmutableSettings.settingsBuilder().put("cluster.name", clusterName).build());
            client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(host, port));
            clients.put(clientKey, (Client)client);
            ESClientFactory.initializeClient((Client)client);
            return client;
        }
    }

    public static Client createLocalClient(String className, String fieldName) {
        String clientKey = "local:" + className + '/' + fieldName;
        Map<String, Client> map = clients;
        synchronized (map) {
            if (clients.containsKey(clientKey)) {
                return clients.get(clientKey);
            }
            try {
                Class<?> clientLocClass = Class.forName(className);
                Field field = clientLocClass.getField(fieldName);
                Client client = (Client)field.get(null);
                clients.put(clientKey, client);
                ESClientFactory.initializeClient(client);
                return client;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException("Error using local elasticsearch client.", e);
            }
        }
    }

    private static void initializeClient(Client client) {
        try {
            client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().execute().actionGet(5000L);
            IndicesExistsRequest request = new IndicesExistsRequest(new String[]{"apiman_gateway"});
            IndicesExistsResponse response = (IndicesExistsResponse)client.admin().indices().exists(request).get();
            if (!response.isExists()) {
                ESClientFactory.createIndex(client, "apiman_gateway");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void createIndex(Client client, String indexName) throws Exception {
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        URL settings = ESClientFactory.class.getResource("index-settings.json");
        String source = IOUtils.toString((URL)settings);
        request.source(source);
        CreateIndexResponse response = (CreateIndexResponse)client.admin().indices().create(request).get();
        if (!response.isAcknowledged()) {
            throw new Exception("Failed to create index: " + indexName);
        }
    }
}

