/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.ISharedStateComponent;
import io.apiman.gateway.engine.es.ESClientFactory;
import io.apiman.gateway.engine.es.beans.PrimitiveBean;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.xcontent.XContentType;

public class ESSharedStateComponent
implements ISharedStateComponent {
    private static final ObjectMapper mapper = new ObjectMapper();
    private Map<String, String> config;
    private Client esClient;

    public ESSharedStateComponent(Map<String, String> config) {
        this.config = config;
    }

    public <T> void getProperty(String namespace, String propertyName, final T defaultValue, final IAsyncResultHandler<T> handler) {
        if (defaultValue == null) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new Exception("Null defaultValue is not allowed.")));
            return;
        }
        String id = this.getPropertyId(namespace, propertyName);
        this.getClient().prepareGet("apiman_gateway", "sharedStateProperty", id).execute((ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                if (response.isExists()) {
                    try {
                        String source = response.getSourceAsString();
                        Object value = null;
                        value = defaultValue.getClass().isPrimitive() || defaultValue instanceof String ? ESSharedStateComponent.this.readPrimitive(source) : mapper.reader(defaultValue.getClass()).readValue(source);
                        handler.handle((Object)AsyncResultImpl.create((Object)value));
                    }
                    catch (Exception e) {
                        handler.handle((Object)AsyncResultImpl.create((Throwable)e));
                    }
                } else {
                    handler.handle((Object)AsyncResultImpl.create((Object)defaultValue));
                }
            }

            public void onFailure(Throwable e) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)e));
            }
        });
    }

    public <T> void setProperty(String namespace, String propertyName, T value, final IAsyncResultHandler<Void> handler) {
        if (value == null) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new Exception("Null value is not allowed.")));
            return;
        }
        String source = null;
        try {
            if (value.getClass().isPrimitive() || value instanceof String) {
                PrimitiveBean pb = new PrimitiveBean();
                pb.setValue(String.valueOf(value));
                pb.setType(value.getClass().getName());
                source = mapper.writeValueAsString((Object)pb);
            } else {
                source = mapper.writeValueAsString(value);
            }
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
            return;
        }
        String id = this.getPropertyId(namespace, propertyName);
        this.getClient().prepareIndex("apiman_gateway", "sharedStateProperty", id).setSource(source).setContentType(XContentType.JSON).execute((ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse response) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            }

            public void onFailure(Throwable e) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)e));
            }
        });
    }

    public <T> void clearProperty(String namespace, String propertyName, final IAsyncResultHandler<Void> handler) {
        String id = this.getPropertyId(namespace, propertyName);
        this.getClient().prepareDelete("apiman_gateway", "sharedStateProperty", id).execute((ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse response) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            }

            public void onFailure(Throwable e) {
                handler.handle((Object)AsyncResultImpl.create((Throwable)e));
            }
        });
    }

    private String getPropertyId(String namespace, String propertyName) {
        String qn = new QName(namespace, propertyName).toString();
        return Base64.encodeBytes((byte[])qn.getBytes());
    }

    protected Object readPrimitive(String source) throws Exception {
        PrimitiveBean pb = (PrimitiveBean)mapper.reader(PrimitiveBean.class).readValue(source);
        String value = pb.getValue();
        Class<?> c = Class.forName(pb.getType());
        if (c == String.class) {
            return value;
        }
        if (c == Long.class) {
            return Long.parseLong(source);
        }
        if (c == Integer.class) {
            return Integer.parseInt(source);
        }
        if (c == Double.class) {
            return Double.parseDouble(source);
        }
        if (c == Boolean.class) {
            return Boolean.parseBoolean(source);
        }
        if (c == Byte.class) {
            return Byte.parseByte(source);
        }
        if (c == Short.class) {
            return Short.parseShort(source);
        }
        if (c == Float.class) {
            return Float.valueOf(Float.parseFloat(source));
        }
        throw new Exception("Unsupported primitive: " + c);
    }

    public synchronized Client getClient() {
        if (this.esClient == null) {
            this.esClient = ESClientFactory.createClient(this.config);
        }
        return this.esClient;
    }

    static {
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

