/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.platforms.war.micro;

import io.apiman.common.servlet.ApimanCorsFilter;
import io.apiman.common.servlet.AuthenticationFilter;
import io.apiman.common.servlet.DisableCachingFilter;
import io.apiman.common.servlet.LocaleFilter;
import io.apiman.common.servlet.RootResourceFilter;
import io.apiman.gateway.engine.components.IBufferFactoryComponent;
import io.apiman.gateway.engine.components.ICacheStoreComponent;
import io.apiman.gateway.engine.components.IPolicyFailureFactoryComponent;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.components.ISharedStateComponent;
import io.apiman.gateway.engine.es.ESCacheStoreComponent;
import io.apiman.gateway.engine.es.ESMetrics;
import io.apiman.gateway.engine.es.ESRateLimiterComponent;
import io.apiman.gateway.engine.es.ESRegistry;
import io.apiman.gateway.engine.es.ESSharedStateComponent;
import io.apiman.gateway.engine.impl.ByteBufferFactoryComponent;
import io.apiman.gateway.engine.impl.DefaultPluginRegistry;
import io.apiman.gateway.engine.policy.PolicyFactoryImpl;
import io.apiman.gateway.platforms.servlet.PolicyFailureFactoryComponent;
import io.apiman.gateway.platforms.servlet.connectors.HttpConnectorFactory;
import io.apiman.gateway.platforms.war.filters.HttpRequestThreadLocalFilter;
import io.apiman.gateway.platforms.war.listeners.WarGatewayBootstrapper;
import io.apiman.gateway.platforms.war.micro.GatewayMicroServiceApplication;
import io.apiman.gateway.platforms.war.micro.User;
import io.apiman.gateway.platforms.war.micro.Users;
import io.apiman.gateway.platforms.war.servlets.WarGatewayServlet;
import java.util.EnumSet;
import java.util.EventListener;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Credential;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;

public class GatewayMicroService {
    private Server server;

    public GatewayMicroService() {
        this.configure();
    }

    protected void configure() {
        this.configureGlobalVars();
        this.configurePluginRegistry();
        this.configureRegistry();
        this.configureConnectorFactory();
        this.configurePolicyFactory();
        this.configureMetrics();
        this.registerComponents();
    }

    protected void configureGlobalVars() {
        System.setProperty("apiman.es.protocol", "http");
        System.setProperty("apiman.es.host", "localhost");
        System.setProperty("apiman.es.port", "9200");
        System.setProperty("apiman.es.cluster-name", "apiman");
    }

    protected void registerComponents() {
        this.registerBufferFactoryComponent();
        this.registerSharedStateComponent();
        this.registerRateLimiterComponent();
        this.registerPolicyFailureFactoryComponent();
        this.registerCacheStoreComponent();
    }

    private void registerBufferFactoryComponent() {
        System.setProperty("apiman-gateway.components." + IBufferFactoryComponent.class.getSimpleName(), ByteBufferFactoryComponent.class.getName());
    }

    protected void registerPolicyFailureFactoryComponent() {
        System.setProperty("apiman-gateway.components." + IPolicyFailureFactoryComponent.class.getSimpleName(), PolicyFailureFactoryComponent.class.getName());
    }

    protected void registerRateLimiterComponent() {
        System.setProperty("apiman-gateway.components." + IRateLimiterComponent.class.getSimpleName(), ESRateLimiterComponent.class.getName());
        System.setProperty("apiman-gateway.components.IRateLimiterComponent.client.type", "jest");
        System.setProperty("apiman-gateway.components.IRateLimiterComponent.client.cluster-name", "${apiman.es.cluster-name}");
        System.setProperty("apiman-gateway.components.IRateLimiterComponent.client.protocol", "${apiman.es.protocol}");
        System.setProperty("apiman-gateway.components.IRateLimiterComponent.client.host", "${apiman.es.host}");
        System.setProperty("apiman-gateway.components.IRateLimiterComponent.client.port", "${apiman.es.port}");
    }

    protected void registerSharedStateComponent() {
        System.setProperty("apiman-gateway.components." + ISharedStateComponent.class.getSimpleName(), ESSharedStateComponent.class.getName());
        System.setProperty("apiman-gateway.components.ISharedStateComponent.client.type", "jest");
        System.setProperty("apiman-gateway.components.ISharedStateComponent.client.cluster-name", "${apiman.es.cluster-name}");
        System.setProperty("apiman-gateway.components.ISharedStateComponent.client.protocol", "${apiman.es.protocol}");
        System.setProperty("apiman-gateway.components.ISharedStateComponent.client.host", "${apiman.es.host}");
        System.setProperty("apiman-gateway.components.ISharedStateComponent.client.port", "${apiman.es.port}");
    }

    protected void registerCacheStoreComponent() {
        System.setProperty("apiman-gateway.components." + ICacheStoreComponent.class.getSimpleName(), ESCacheStoreComponent.class.getName());
        System.setProperty("apiman-gateway.components.ICacheStoreComponent.client.type", "jest");
        System.setProperty("apiman-gateway.components.ICacheStoreComponent.client.cluster-name", "${apiman.es.cluster-name}");
        System.setProperty("apiman-gateway.components.ICacheStoreComponent.client.protocol", "${apiman.es.protocol}");
        System.setProperty("apiman-gateway.components.ICacheStoreComponent.client.host", "${apiman.es.host}");
        System.setProperty("apiman-gateway.components.ICacheStoreComponent.client.port", "${apiman.es.port}");
        System.setProperty("apiman-gateway.components.ICacheStoreComponent.client.index", "apiman_cache");
    }

    protected void configurePolicyFactory() {
        System.setProperty("apiman-gateway.policy-factory", PolicyFactoryImpl.class.getName());
    }

    protected void configureConnectorFactory() {
        System.setProperty("apiman-gateway.connector-factory", HttpConnectorFactory.class.getName());
    }

    protected void configurePluginRegistry() {
        System.setProperty("apiman-gateway.plugin-registry", DefaultPluginRegistry.class.getName());
    }

    protected void configureRegistry() {
        System.setProperty("apiman-gateway.registry", ESRegistry.class.getName());
        System.setProperty("apiman-gateway.registry.client.type", "jest");
        System.setProperty("apiman-gateway.registry.client.cluster-name", "${apiman.es.cluster-name}");
        System.setProperty("apiman-gateway.registry.client.protocol", "${apiman.es.protocol}");
        System.setProperty("apiman-gateway.registry.client.host", "${apiman.es.host}");
        System.setProperty("apiman-gateway.registry.client.port", "${apiman.es.port}");
    }

    protected void configureMetrics() {
        System.setProperty("apiman-gateway.metrics", ESMetrics.class.getName());
        System.setProperty("apiman-gateway.metrics.client.type", "jest");
        System.setProperty("apiman-gateway.metrics.client.cluster-name", System.getProperty("apiman-test.es-metrics.cluster-name", "${apiman.es.cluster-name}"));
        System.setProperty("apiman-gateway.metrics.client.protocol", System.getProperty("apiman-test.es-metrics.host", "${apiman.es.protocol}"));
        System.setProperty("apiman-gateway.metrics.client.host", System.getProperty("apiman-test.es-metrics.host", "${apiman.es.host}"));
        System.setProperty("apiman-gateway.metrics.client.port", System.getProperty("apiman-test.es-metrics.port", "${apiman.es.port}"));
        System.setProperty("apiman-gateway.metrics.client.index", System.getProperty("apiman-test.es-metrics.index", "apiman_metrics"));
    }

    public void start() throws Exception {
        long startTime = System.currentTimeMillis();
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        this.addModulesToJetty(handlers);
        int serverPort = this.serverPort();
        System.out.println("**** Starting Gateway (" + this.getClass().getSimpleName() + ") on port: " + serverPort);
        this.server = new Server(serverPort);
        this.server.setHandler((Handler)handlers);
        this.server.start();
        long endTime = System.currentTimeMillis();
        System.out.println("******* Started in " + (endTime - startTime) + "ms");
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public int serverPort() {
        return Integer.parseInt(System.getProperty("apiman.micro.gateway.port", "7777"));
    }

    protected void addModulesToJetty(ContextHandlerCollection handlers) throws Exception {
        ServletContextHandler gatewayApiServer = new ServletContextHandler(1);
        this.addSecurityHandler(gatewayApiServer);
        gatewayApiServer.setContextPath("/api");
        gatewayApiServer.addEventListener((EventListener)new ResteasyBootstrap());
        gatewayApiServer.addEventListener((EventListener)new WarGatewayBootstrapper());
        gatewayApiServer.addFilter(HttpRequestThreadLocalFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        gatewayApiServer.addFilter(LocaleFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        gatewayApiServer.addFilter(ApimanCorsFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        gatewayApiServer.addFilter(DisableCachingFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.addApiAuthFilter(gatewayApiServer);
        gatewayApiServer.addFilter(RootResourceFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        ServletHolder resteasyServlet = new ServletHolder((Servlet)new HttpServletDispatcher());
        resteasyServlet.setInitParameter("javax.ws.rs.Application", GatewayMicroServiceApplication.class.getName());
        gatewayApiServer.addServlet(resteasyServlet, "/*");
        gatewayApiServer.setInitParameter("resteasy.servlet.mapping.prefix", "");
        handlers.addHandler((Handler)gatewayApiServer);
        ServletContextHandler gatewayServer = new ServletContextHandler(1);
        this.addSecurityHandler(gatewayServer);
        gatewayServer.setContextPath("/gateway");
        ServletHolder servlet = new ServletHolder((Servlet)new WarGatewayServlet());
        gatewayServer.addServlet(servlet, "/*");
        handlers.addHandler((Handler)gatewayServer);
    }

    protected void addSecurityHandler(ServletContextHandler apiManServer) {
        apiManServer.setSecurityHandler(this.createSecurityHandler());
    }

    protected void addApiAuthFilter(ServletContextHandler apiManServer) {
        apiManServer.addFilter(AuthenticationFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    protected SecurityHandler createSecurityHandler() {
        HashLoginService l = new HashLoginService();
        for (User user : Users.getUsers()) {
            l.putUser(user.getId(), Credential.getCredential((String)user.getPassword()), user.getRolesAsArray());
        }
        l.setName("apimanrealm");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("apimanrealm");
        csh.setLoginService((LoginService)l);
        return csh;
    }

    public void join() throws InterruptedException {
        this.server.join();
    }
}

