/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.test.server;

import io.apiman.test.common.mock.EchoServlet;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class EchoServer {
    private Server server;
    private int port;

    public EchoServer(int port) {
        this.port = port;
    }

    public void start() throws Exception {
        long startTime = System.currentTimeMillis();
        System.out.println("**** Starting Server (" + this.getClass().getSimpleName() + ")");
        this.preStart();
        ContextHandlerCollection handlers = new ContextHandlerCollection();
        this.addModulesToJetty(handlers);
        this.server = new Server(this.port);
        this.server.setHandler((Handler)handlers);
        this.server.start();
        long endTime = System.currentTimeMillis();
        System.out.println("******* Started in " + (endTime - startTime) + "ms");
    }

    private void preStart() {
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addModulesToJetty(ContextHandlerCollection handlers) throws Exception {
        ServletContextHandler server = new ServletContextHandler(1);
        server.setContextPath("/");
        ServletHolder servlet = new ServletHolder((Servlet)new EchoServlet());
        server.addServlet(servlet, "/");
        handlers.addHandler((Handler)server);
    }

    public static void main(String[] args) throws Exception {
        new EchoServer(9999).start();
        while (Boolean.TRUE.booleanValue()) {
            Thread.sleep(1000L);
        }
    }
}

