/*
 * Copyright 2015 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.apiman.manager.api.security.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.servlet.http.HttpServletRequest;

/**
 * An alternative security context used when protected by keycloak.
 *
 * @author eric.wittmann@redhat.com
 */
@ApplicationScoped @Alternative
public class KeycloakSecurityContext extends AbstractSecurityContext {

    /**
     * Constructor.
     */
    public KeycloakSecurityContext() {
    }

    /**
     * @see io.apiman.manager.api.security.ISecurityContext#getRequestHeader(java.lang.String)
     */
    @Override
    public String getRequestHeader(String headerName) {
        return DefaultSecurityContext.servletRequest.get().getHeader(headerName);
    }

    /**
     * @see io.apiman.manager.api.security.ISecurityContext#getCurrentUser()
     */
    @Override
    public String getCurrentUser() {
        return DefaultSecurityContext.servletRequest.get().getRemoteUser();
    }

    /**
     * @see io.apiman.manager.api.security.impl.DefaultSecurityContext#getFullName()
     */
    @Override
    public String getFullName() {
        HttpServletRequest request = DefaultSecurityContext.servletRequest.get();
        org.keycloak.KeycloakSecurityContext session = (org.keycloak.KeycloakSecurityContext) request.getAttribute(org.keycloak.KeycloakSecurityContext.class.getName());
        if (session != null) {
            return session.getToken().getName();
        } else {
            return null;
        }
    }

    /**
     * @see io.apiman.manager.api.security.impl.DefaultSecurityContext#getEmail()
     */
    @Override
    public String getEmail() {
        HttpServletRequest request = DefaultSecurityContext.servletRequest.get();
        org.keycloak.KeycloakSecurityContext session = (org.keycloak.KeycloakSecurityContext) request.getAttribute(org.keycloak.KeycloakSecurityContext.class.getName());
        if (session != null) {
            return session.getToken().getEmail();
        } else {
            return null;
        }
    }

    /**
     * @see io.apiman.manager.api.security.ISecurityContext#isAdmin()
     */
    @Override
    public boolean isAdmin() {
        // TODO warning - hard coded role value here
        return DefaultSecurityContext.servletRequest.get().isUserInRole("apiadmin"); //$NON-NLS-1$
    }

}
