/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.security.impl;

import io.apiman.manager.api.security.impl.AbstractSecurityContext;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.servlet.http.HttpServletRequest;

@ApplicationScoped
@Alternative
public class DefaultSecurityContext
extends AbstractSecurityContext {
    public static final ThreadLocal<HttpServletRequest> servletRequest = new ThreadLocal();

    @Override
    public String getRequestHeader(String headerName) {
        return servletRequest.get().getHeader(headerName);
    }

    @Override
    public String getCurrentUser() {
        return servletRequest.get().getRemoteUser();
    }

    @Override
    public String getEmail() {
        return null;
    }

    @Override
    public String getFullName() {
        return null;
    }

    @Override
    public boolean isAdmin() {
        return servletRequest.get().isUserInRole("apiadmin");
    }

    protected static void setServletRequest(HttpServletRequest request) {
        servletRequest.set(request);
    }

    protected static void clearPermissions() {
        AbstractSecurityContext.clearPermissions();
    }

    protected static void clearServletRequest() {
        servletRequest.remove();
    }
}

