package org.jboss.errai.enterprise.client.jaxrs;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import io.apiman.manager.api.beans.actions.ActionBean;
import io.apiman.manager.api.beans.apps.ApplicationBean;
import io.apiman.manager.api.beans.apps.ApplicationVersionBean;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.contracts.NewContractBean;
import io.apiman.manager.api.beans.idm.GrantRolesBean;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.idm.UserPermissionsBean;
import io.apiman.manager.api.beans.members.MemberBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyChainBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.services.ServiceBean;
import io.apiman.manager.api.beans.services.ServiceVersionBean;
import io.apiman.manager.api.beans.summary.ApplicationSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.beans.summary.PlanSummaryBean;
import io.apiman.manager.api.beans.summary.ServicePlanSummaryBean;
import io.apiman.manager.api.beans.summary.ServiceSummaryBean;
import io.apiman.manager.api.beans.system.SystemStatusBean;
import io.apiman.manager.api.rest.contract.IActionResource;
import io.apiman.manager.api.rest.contract.ICurrentUserResource;
import io.apiman.manager.api.rest.contract.IOrganizationResource;
import io.apiman.manager.api.rest.contract.IPermissionsResource;
import io.apiman.manager.api.rest.contract.IPolicyDefinitionResource;
import io.apiman.manager.api.rest.contract.IRoleResource;
import io.apiman.manager.api.rest.contract.ISearchResource;
import io.apiman.manager.api.rest.contract.ISystemResource;
import io.apiman.manager.api.rest.contract.IUserResource;
import io.apiman.manager.ui.client.local.services.rest.AuthInterceptor;
import io.apiman.manager.ui.client.local.services.rest.RestClientExceptionMapper;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.common.client.framework.CallContextStatus;
import org.jboss.errai.common.client.framework.ProxyProvider;
import org.jboss.errai.common.client.framework.RemoteServiceProxyFactory;
import org.jboss.errai.common.client.util.CreationalCallback;
import org.jboss.errai.enterprise.client.jaxrs.api.ResponseCallback;
import org.jboss.errai.enterprise.client.jaxrs.api.interceptor.RestCallContext;

public class JaxrsProxyLoaderImpl implements JaxrsProxyLoader { public void loadProxies() {
    class io_apiman_manager_api_rest_contract_ISystemResourceImpl extends AbstractJaxrsProxy implements ISystemResource {
      private RemoteCallback remoteCallback;
      private ErrorCallback errorCallback;
      public io_apiman_manager_api_rest_contract_ISystemResourceImpl() {
        setExceptionMapper(new RestClientExceptionMapper());
      }

      public RemoteCallback getRemoteCallback() {
        return remoteCallback;
      }

      public void setRemoteCallback(RemoteCallback callback) {
        remoteCallback = callback;
      }

      public ErrorCallback getErrorCallback() {
        return errorCallback;
      }

      public void setErrorCallback(ErrorCallback callback) {
        errorCallback = callback;
      }

      public SystemStatusBean getStatus() {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("system/status");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getStatus";
            }
            public Class getReturnType() {
              return SystemStatusBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=status)";
                  }
                  public String value() {
                    return "status";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=system)";
                  }
                  public String value() {
                    return "system";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_ISystemResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SystemStatusBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ISystemResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ISystemResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ISystemResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ISystemResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("system/status");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_ISystemResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }
    }
    RemoteServiceProxyFactory.addRemoteProxy(ISystemResource.class, new ProxyProvider() {
      public Object getProxy() {
        return new io_apiman_manager_api_rest_contract_ISystemResourceImpl();
      }
    });
    class io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl extends AbstractJaxrsProxy implements IPolicyDefinitionResource {
      private RemoteCallback remoteCallback;
      private ErrorCallback errorCallback;
      public io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl() {
        setExceptionMapper(new RestClientExceptionMapper());
      }

      public RemoteCallback getRemoteCallback() {
        return remoteCallback;
      }

      public void setRemoteCallback(RemoteCallback callback) {
        remoteCallback = callback;
      }

      public ErrorCallback getErrorCallback() {
        return errorCallback;
      }

      public void setErrorCallback(ErrorCallback callback) {
        errorCallback = callback;
      }

      public List list() {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("policyDefs");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "list";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=policyDefs)";
                  }
                  public String value() {
                    return "policyDefs";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, PolicyDefinitionBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("policyDefs");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public PolicyDefinitionBean create(final PolicyDefinitionBean a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("policyDefs");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "create";
            }
            public Class getReturnType() {
              return PolicyDefinitionBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=policyDefs)";
                  }
                  public String value() {
                    return "policyDefs";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a0), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PolicyDefinitionBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("policyDefs");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public PolicyDefinitionBean get(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("policyDefs/{policyDefinitionId}".replace("{policyDefinitionId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "get";
            }
            public Class getReturnType() {
              return PolicyDefinitionBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={policyDefinitionId})";
                  }
                  public String value() {
                    return "{policyDefinitionId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=policyDefs)";
                  }
                  public String value() {
                    return "policyDefs";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PolicyDefinitionBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("policyDefs/{policyDefinitionId}".replace("{policyDefinitionId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void update(final String a0, final PolicyDefinitionBean a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("policyDefs/{policyDefinitionId}".replace("{policyDefinitionId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "update";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={policyDefinitionId})";
                  }
                  public String value() {
                    return "{policyDefinitionId}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=policyDefs)";
                  }
                  public String value() {
                    return "policyDefs";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a1), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("policyDefs/{policyDefinitionId}".replace("{policyDefinitionId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public void delete(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("policyDefs/{policyDefinitionId}".replace("{policyDefinitionId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "delete";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new DELETE() {
                  public Class annotationType() {
                    return DELETE.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.DELETE()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={policyDefinitionId})";
                  }
                  public String value() {
                    return "{policyDefinitionId}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=policyDefs)";
                  }
                  public String value() {
                    return "policyDefs";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("policyDefs/{policyDefinitionId}".replace("{policyDefinitionId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl.this.handleError(throwable, null, null);
        }
      }
    }
    RemoteServiceProxyFactory.addRemoteProxy(IPolicyDefinitionResource.class, new ProxyProvider() {
      public Object getProxy() {
        return new io_apiman_manager_api_rest_contract_IPolicyDefinitionResourceImpl();
      }
    });
    class io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl extends AbstractJaxrsProxy implements ICurrentUserResource {
      private RemoteCallback remoteCallback;
      private ErrorCallback errorCallback;
      public io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl() {
        setExceptionMapper(new RestClientExceptionMapper());
      }

      public RemoteCallback getRemoteCallback() {
        return remoteCallback;
      }

      public void setRemoteCallback(RemoteCallback callback) {
        remoteCallback = callback;
      }

      public ErrorCallback getErrorCallback() {
        return errorCallback;
      }

      public void setErrorCallback(ErrorCallback callback) {
        errorCallback = callback;
      }

      public UserBean getInfo() {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("currentuser/info");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getInfo";
            }
            public Class getReturnType() {
              return UserBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=info)";
                  }
                  public String value() {
                    return "info";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=currentuser)";
                  }
                  public String value() {
                    return "currentuser";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, UserBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("currentuser/info");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List getOrganizations() {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("currentuser/organizations");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getOrganizations";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=currentuser)";
                  }
                  public String value() {
                    return "currentuser";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, OrganizationSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("currentuser/organizations");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List getApplications() {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("currentuser/applications");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getApplications";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=applications)";
                  }
                  public String value() {
                    return "applications";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=currentuser)";
                  }
                  public String value() {
                    return "currentuser";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, ApplicationSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("currentuser/applications");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List getServices() {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("currentuser/services");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getServices";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=services)";
                  }
                  public String value() {
                    return "services";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=currentuser)";
                  }
                  public String value() {
                    return "currentuser";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, ServiceSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("currentuser/services");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }
    }
    RemoteServiceProxyFactory.addRemoteProxy(ICurrentUserResource.class, new ProxyProvider() {
      public Object getProxy() {
        return new io_apiman_manager_api_rest_contract_ICurrentUserResourceImpl();
      }
    });
    class io_apiman_manager_api_rest_contract_IActionResourceImpl extends AbstractJaxrsProxy implements IActionResource {
      private RemoteCallback remoteCallback;
      private ErrorCallback errorCallback;
      public io_apiman_manager_api_rest_contract_IActionResourceImpl() {
        setExceptionMapper(new RestClientExceptionMapper());
      }

      public RemoteCallback getRemoteCallback() {
        return remoteCallback;
      }

      public void setRemoteCallback(RemoteCallback callback) {
        remoteCallback = callback;
      }

      public ErrorCallback getErrorCallback() {
        return errorCallback;
      }

      public void setErrorCallback(ErrorCallback callback) {
        errorCallback = callback;
      }

      public void performAction(final ActionBean a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("actions");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "performAction";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=actions)";
                  }
                  public String value() {
                    return "actions";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IActionResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a0), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IActionResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IActionResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IActionResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IActionResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("actions");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IActionResourceImpl.this.handleError(throwable, null, null);
        }
      }
    }
    RemoteServiceProxyFactory.addRemoteProxy(IActionResource.class, new ProxyProvider() {
      public Object getProxy() {
        return new io_apiman_manager_api_rest_contract_IActionResourceImpl();
      }
    });
    class io_apiman_manager_api_rest_contract_IRoleResourceImpl extends AbstractJaxrsProxy implements IRoleResource {
      private RemoteCallback remoteCallback;
      private ErrorCallback errorCallback;
      public io_apiman_manager_api_rest_contract_IRoleResourceImpl() {
        setExceptionMapper(new RestClientExceptionMapper());
      }

      public RemoteCallback getRemoteCallback() {
        return remoteCallback;
      }

      public void setRemoteCallback(RemoteCallback callback) {
        remoteCallback = callback;
      }

      public ErrorCallback getErrorCallback() {
        return errorCallback;
      }

      public void setErrorCallback(ErrorCallback callback) {
        errorCallback = callback;
      }

      public RoleBean create(final RoleBean a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("roles");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "create";
            }
            public Class getReturnType() {
              return RoleBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=roles)";
                  }
                  public String value() {
                    return "roles";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a0), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, RoleBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("roles");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List list() {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("roles");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "list";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=roles)";
                  }
                  public String value() {
                    return "roles";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, RoleBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("roles");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public RoleBean get(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("roles/{roleId}".replace("{roleId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "get";
            }
            public Class getReturnType() {
              return RoleBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={roleId})";
                  }
                  public String value() {
                    return "{roleId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=roles)";
                  }
                  public String value() {
                    return "roles";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, RoleBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("roles/{roleId}".replace("{roleId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void update(final String a0, final RoleBean a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("roles/{roleId}".replace("{roleId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "update";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={roleId})";
                  }
                  public String value() {
                    return "{roleId}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=roles)";
                  }
                  public String value() {
                    return "roles";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a1), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("roles/{roleId}".replace("{roleId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public void delete(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("roles/{roleId}".replace("{roleId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "delete";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new DELETE() {
                  public Class annotationType() {
                    return DELETE.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.DELETE()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={roleId})";
                  }
                  public String value() {
                    return "{roleId}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=roles)";
                  }
                  public String value() {
                    return "roles";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("roles/{roleId}".replace("{roleId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public SearchResultsBean search(final SearchCriteriaBean a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("roles/search");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "search";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=search)";
                  }
                  public String value() {
                    return "search";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=roles)";
                  }
                  public String value() {
                    return "roles";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a0), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, RoleBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("roles/search");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IRoleResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }
    }
    RemoteServiceProxyFactory.addRemoteProxy(IRoleResource.class, new ProxyProvider() {
      public Object getProxy() {
        return new io_apiman_manager_api_rest_contract_IRoleResourceImpl();
      }
    });
    class io_apiman_manager_api_rest_contract_IOrganizationResourceImpl extends AbstractJaxrsProxy implements IOrganizationResource {
      private RemoteCallback remoteCallback;
      private ErrorCallback errorCallback;
      public io_apiman_manager_api_rest_contract_IOrganizationResourceImpl() {
        setExceptionMapper(new RestClientExceptionMapper());
      }

      public RemoteCallback getRemoteCallback() {
        return remoteCallback;
      }

      public void setRemoteCallback(RemoteCallback callback) {
        remoteCallback = callback;
      }

      public ErrorCallback getErrorCallback() {
        return errorCallback;
      }

      public void setErrorCallback(ErrorCallback callback) {
        errorCallback = callback;
      }

      public OrganizationBean create(final OrganizationBean a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "create";
            }
            public Class getReturnType() {
              return OrganizationBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a0), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, OrganizationBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public OrganizationBean get(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "get";
            }
            public Class getReturnType() {
              return OrganizationBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId})";
                  }
                  public String value() {
                    return "{organizationId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, OrganizationBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void update(final String a0, final OrganizationBean a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "update";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId})";
                  }
                  public String value() {
                    return "{organizationId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a1), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public SearchResultsBean activity(final String a0, final int a1, final int a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/activity".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0))).append("?").append("count").append("=").append(URL.encodeQueryString(new Integer(a2).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(new Integer(a1).toString()));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "activity";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/activity)";
                  }
                  public String value() {
                    return "{organizationId}/activity";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, AuditEntryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/activity".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0]))).append("?").append("count").append("=").append(URL.encodeQueryString(((Integer) parameters[2] == null ? "" : (Integer) parameters[2]).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(((Integer) parameters[1] == null ? "" : (Integer) parameters[1]).toString()));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public ApplicationBean createApp(final String a0, final ApplicationBean a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "createApp";
            }
            public Class getReturnType() {
              return ApplicationBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications)";
                  }
                  public String value() {
                    return "{organizationId}/applications";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a1), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, ApplicationBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public ApplicationBean getApp(final String a0, final String a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getApp";
            }
            public Class getReturnType() {
              return ApplicationBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId})";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, ApplicationBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public SearchResultsBean getAppActivity(final String a0, final String a1, final int a2, final int a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/activity".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1))).append("?").append("count").append("=").append(URL.encodeQueryString(new Integer(a3).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(new Integer(a2).toString()));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getAppActivity";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/activity)";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/activity";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, AuditEntryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/activity".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1]))).append("?").append("count").append("=").append(URL.encodeQueryString(((Integer) parameters[3] == null ? "" : (Integer) parameters[3]).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(((Integer) parameters[2] == null ? "" : (Integer) parameters[2]).toString()));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List listApps(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "listApps";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications)";
                  }
                  public String value() {
                    return "{organizationId}/applications";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, ApplicationSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void updateApp(final String a0, final String a1, final ApplicationBean a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "updateApp";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId})";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a2), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public ApplicationVersionBean createAppVersion(final String a0, final String a1, final ApplicationVersionBean a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "createAppVersion";
            }
            public Class getReturnType() {
              return ApplicationVersionBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions)";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a2), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, ApplicationVersionBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List listAppVersions(final String a0, final String a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "listAppVersions";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions)";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, ApplicationVersionBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public ApplicationVersionBean getAppVersion(final String a0, final String a1, final String a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getAppVersion";
            }
            public Class getReturnType() {
              return ApplicationVersionBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version})";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, ApplicationVersionBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public SearchResultsBean getAppVersionActivity(final String a0, final String a1, final String a2, final int a3, final int a4) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/activity".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2))).append("?").append("count").append("=").append(URL.encodeQueryString(new Integer(a4).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(new Integer(a3).toString()));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getAppVersionActivity";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version}/activity)";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}/activity";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, AuditEntryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/activity".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2]))).append("?").append("count").append("=").append(URL.encodeQueryString(((Integer) parameters[4] == null ? "" : (Integer) parameters[4]).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(((Integer) parameters[3] == null ? "" : (Integer) parameters[3]).toString()));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3, a4 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void updateAppVersion(final String a0, final String a1, final String a2, final ApplicationVersionBean a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "updateAppVersion";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version})";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a3), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public ContractBean createContract(final String a0, final String a1, final String a2, final NewContractBean a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/contracts".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "createContract";
            }
            public Class getReturnType() {
              return ContractBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version}/contracts)";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}/contracts";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a3), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, ContractBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/contracts".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public ContractBean getContract(final String a0, final String a1, final String a2, final Long a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/contracts/{contractId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)).replace("{contractId}", URL.encodePathSegment(a3 == null ? "" : a3.toString())));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getContract";
            }
            public Class getReturnType() {
              return ContractBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version}/contracts/{contractId})";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}/contracts/{contractId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, ContractBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/contracts/{contractId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])).replace("{contractId}", URL.encodePathSegment(((Long) parameters[3] == null ? "" : (Long) parameters[3]).toString())));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List listContracts(final String a0, final String a1, final String a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/contracts".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "listContracts";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version}/contracts)";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}/contracts";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, ContractSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/contracts".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void deleteContract(final String a0, final String a1, final String a2, final Long a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/contracts/{contractId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)).replace("{contractId}", URL.encodePathSegment(a3 == null ? "" : a3.toString())));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "deleteContract";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new DELETE() {
                  public Class annotationType() {
                    return DELETE.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.DELETE()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version}/contracts/{contractId})";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}/contracts/{contractId}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/contracts/{contractId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])).replace("{contractId}", URL.encodePathSegment(((Long) parameters[3] == null ? "" : (Long) parameters[3]).toString())));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public PolicyBean createAppPolicy(final String a0, final String a1, final String a2, final PolicyBean a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/policies".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "createAppPolicy";
            }
            public Class getReturnType() {
              return PolicyBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version}/policies)";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}/policies";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a3), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PolicyBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/policies".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public PolicyBean getAppPolicy(final String a0, final String a1, final String a2, final long a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)).replace("{policyId}", URL.encodePathSegment(new Long(a3).toString())));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getAppPolicy";
            }
            public Class getReturnType() {
              return PolicyBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version}/policies/{policyId})";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}/policies/{policyId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PolicyBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])).replace("{policyId}", URL.encodePathSegment(((Long) parameters[3] == null ? "" : (Long) parameters[3]).toString())));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void updateAppPolicy(final String a0, final String a1, final String a2, final long a3, final PolicyBean a4) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)).replace("{policyId}", URL.encodePathSegment(new Long(a3).toString())));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "updateAppPolicy";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version}/policies/{policyId})";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}/policies/{policyId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a4), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])).replace("{policyId}", URL.encodePathSegment(((Long) parameters[3] == null ? "" : (Long) parameters[3]).toString())));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3, a4 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public void deleteAppPolicy(final String a0, final String a1, final String a2, final long a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)).replace("{policyId}", URL.encodePathSegment(new Long(a3).toString())));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "deleteAppPolicy";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new DELETE() {
                  public Class annotationType() {
                    return DELETE.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.DELETE()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version}/policies/{policyId})";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}/policies/{policyId}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])).replace("{policyId}", URL.encodePathSegment(((Long) parameters[3] == null ? "" : (Long) parameters[3]).toString())));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public List listAppPolicies(final String a0, final String a1, final String a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/policies".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "listAppPolicies";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version}/policies)";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}/policies";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, PolicyBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/policies".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void reorderApplicationPolicies(final String a0, final String a1, final String a2, final PolicyChainBean a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/reorderPolicies".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{applicationId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "reorderApplicationPolicies";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/applications/{applicationId}/versions/{version}/reorderPolicies)";
                  }
                  public String value() {
                    return "{organizationId}/applications/{applicationId}/versions/{version}/reorderPolicies";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a3), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/applications/{applicationId}/versions/{version}/reorderPolicies".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{applicationId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public ServiceBean createService(final String a0, final ServiceBean a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "createService";
            }
            public Class getReturnType() {
              return ServiceBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services)";
                  }
                  public String value() {
                    return "{organizationId}/services";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a1), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, ServiceBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public ServiceBean getService(final String a0, final String a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getService";
            }
            public Class getReturnType() {
              return ServiceBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId})";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, ServiceBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List listServices(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "listServices";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services)";
                  }
                  public String value() {
                    return "{organizationId}/services";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, ServiceSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void updateService(final String a0, final String a1, final ServiceBean a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "updateService";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId})";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a2), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public SearchResultsBean getServiceActivity(final String a0, final String a1, final int a2, final int a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/activity".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1))).append("?").append("count").append("=").append(URL.encodeQueryString(new Integer(a3).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(new Integer(a2).toString()));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getServiceActivity";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/activity)";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/activity";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, AuditEntryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/activity".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1]))).append("?").append("count").append("=").append(URL.encodeQueryString(((Integer) parameters[3] == null ? "" : (Integer) parameters[3]).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(((Integer) parameters[2] == null ? "" : (Integer) parameters[2]).toString()));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public ServiceVersionBean createServiceVersion(final String a0, final String a1, final ServiceVersionBean a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "createServiceVersion";
            }
            public Class getReturnType() {
              return ServiceVersionBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions)";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a2), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, ServiceVersionBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List listServiceVersions(final String a0, final String a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "listServiceVersions";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions)";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, ServiceVersionBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public ServiceVersionBean getServiceVersion(final String a0, final String a1, final String a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getServiceVersion";
            }
            public Class getReturnType() {
              return ServiceVersionBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions/{version})";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions/{version}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, ServiceVersionBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void updateServiceVersion(final String a0, final String a1, final String a2, final ServiceVersionBean a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "updateServiceVersion";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions/{version})";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions/{version}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a3), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public SearchResultsBean getServiceVersionActivity(final String a0, final String a1, final String a2, final int a3, final int a4) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/activity".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2))).append("?").append("count").append("=").append(URL.encodeQueryString(new Integer(a4).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(new Integer(a3).toString()));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getServiceVersionActivity";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions/{version}/activity)";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions/{version}/activity";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, AuditEntryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/activity".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2]))).append("?").append("count").append("=").append(URL.encodeQueryString(((Integer) parameters[4] == null ? "" : (Integer) parameters[4]).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(((Integer) parameters[3] == null ? "" : (Integer) parameters[3]).toString()));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3, a4 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List getServiceVersionPlans(final String a0, final String a1, final String a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/plans".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getServiceVersionPlans";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions/{version}/plans)";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions/{version}/plans";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, ServicePlanSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/plans".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public PolicyBean createServicePolicy(final String a0, final String a1, final String a2, final PolicyBean a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/policies".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "createServicePolicy";
            }
            public Class getReturnType() {
              return PolicyBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions/{version}/policies)";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions/{version}/policies";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a3), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PolicyBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/policies".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public PolicyBean getServicePolicy(final String a0, final String a1, final String a2, final long a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)).replace("{policyId}", URL.encodePathSegment(new Long(a3).toString())));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getServicePolicy";
            }
            public Class getReturnType() {
              return PolicyBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions/{version}/policies/{policyId})";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions/{version}/policies/{policyId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PolicyBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])).replace("{policyId}", URL.encodePathSegment(((Long) parameters[3] == null ? "" : (Long) parameters[3]).toString())));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void updateServicePolicy(final String a0, final String a1, final String a2, final long a3, final PolicyBean a4) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)).replace("{policyId}", URL.encodePathSegment(new Long(a3).toString())));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "updateServicePolicy";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions/{version}/policies/{policyId})";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions/{version}/policies/{policyId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a4), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])).replace("{policyId}", URL.encodePathSegment(((Long) parameters[3] == null ? "" : (Long) parameters[3]).toString())));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3, a4 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public void deleteServicePolicy(final String a0, final String a1, final String a2, final long a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)).replace("{policyId}", URL.encodePathSegment(new Long(a3).toString())));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "deleteServicePolicy";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new DELETE() {
                  public Class annotationType() {
                    return DELETE.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.DELETE()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions/{version}/policies/{policyId})";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions/{version}/policies/{policyId}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])).replace("{policyId}", URL.encodePathSegment(((Long) parameters[3] == null ? "" : (Long) parameters[3]).toString())));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public List listServicePolicies(final String a0, final String a1, final String a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/policies".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "listServicePolicies";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions/{version}/policies)";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions/{version}/policies";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, PolicyBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/policies".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void reorderServicePolicies(final String a0, final String a1, final String a2, final PolicyChainBean a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/reorderPolicies".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "reorderServicePolicies";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions/{version}/reorderPolicies)";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions/{version}/reorderPolicies";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a3), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/reorderPolicies".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public PolicyChainBean getServicePolicyChain(final String a0, final String a1, final String a2, final String a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/plans/{planId}/policyChain".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)).replace("{planId}", URL.encodePathSegment(a3 == null ? "" : a3)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getServicePolicyChain";
            }
            public Class getReturnType() {
              return PolicyChainBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions/{version}/plans/{planId}/policyChain)";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions/{version}/plans/{planId}/policyChain";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PolicyChainBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/plans/{planId}/policyChain".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])).replace("{planId}", URL.encodePathSegment((String) parameters[3] == null ? "" : (String) parameters[3])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List getServiceVersionContracts(final String a0, final String a1, final String a2, final int a3, final int a4) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/contracts".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{serviceId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2))).append("?").append("count").append("=").append(URL.encodeQueryString(new Integer(a4).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(new Integer(a3).toString()));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getServiceVersionContracts";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/services/{serviceId}/versions/{version}/contracts)";
                  }
                  public String value() {
                    return "{organizationId}/services/{serviceId}/versions/{version}/contracts";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, ContractSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/services/{serviceId}/versions/{version}/contracts".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{serviceId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2]))).append("?").append("count").append("=").append(URL.encodeQueryString(((Integer) parameters[4] == null ? "" : (Integer) parameters[4]).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(((Integer) parameters[3] == null ? "" : (Integer) parameters[3]).toString()));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3, a4 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public PlanBean createPlan(final String a0, final PlanBean a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "createPlan";
            }
            public Class getReturnType() {
              return PlanBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans)";
                  }
                  public String value() {
                    return "{organizationId}/plans";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a1), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PlanBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public PlanBean getPlan(final String a0, final String a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getPlan";
            }
            public Class getReturnType() {
              return PlanBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId})";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PlanBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public SearchResultsBean getPlanActivity(final String a0, final String a1, final int a2, final int a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}/activity".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1))).append("?").append("count").append("=").append(URL.encodeQueryString(new Integer(a3).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(new Integer(a2).toString()));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getPlanActivity";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId}/activity)";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}/activity";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, AuditEntryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}/activity".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1]))).append("?").append("count").append("=").append(URL.encodeQueryString(((Integer) parameters[3] == null ? "" : (Integer) parameters[3]).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(((Integer) parameters[2] == null ? "" : (Integer) parameters[2]).toString()));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List listPlans(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "listPlans";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans)";
                  }
                  public String value() {
                    return "{organizationId}/plans";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, PlanSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void updatePlan(final String a0, final String a1, final PlanBean a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "updatePlan";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId})";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a2), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public PlanVersionBean createPlanVersion(final String a0, final String a1, final PlanVersionBean a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}/versions".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "createPlanVersion";
            }
            public Class getReturnType() {
              return PlanVersionBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId}/versions)";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}/versions";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a2), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PlanVersionBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}/versions".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List listPlanVersions(final String a0, final String a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}/versions".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "listPlanVersions";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId}/versions)";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}/versions";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, PlanVersionBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}/versions".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public PlanVersionBean getPlanVersion(final String a0, final String a1, final String a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}/versions/{version}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getPlanVersion";
            }
            public Class getReturnType() {
              return PlanVersionBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId}/versions/{version})";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}/versions/{version}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PlanVersionBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}/versions/{version}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public SearchResultsBean getPlanVersionActivity(final String a0, final String a1, final String a2, final int a3, final int a4) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/activity".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2))).append("?").append("count").append("=").append(URL.encodeQueryString(new Integer(a4).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(new Integer(a3).toString()));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getPlanVersionActivity";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId}/versions/{version}/activity)";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}/versions/{version}/activity";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, AuditEntryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/activity".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2]))).append("?").append("count").append("=").append(URL.encodeQueryString(((Integer) parameters[4] == null ? "" : (Integer) parameters[4]).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(((Integer) parameters[3] == null ? "" : (Integer) parameters[3]).toString()));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3, a4 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void updatePlanVersion(final String a0, final String a1, final String a2, final PlanVersionBean a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}/versions/{version}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "updatePlanVersion";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId}/versions/{version})";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}/versions/{version}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a3), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}/versions/{version}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public SearchResultsBean searchPlans(final String a0, final SearchCriteriaBean a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/search".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "searchPlans";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/search)";
                  }
                  public String value() {
                    return "{organizationId}/plans/search";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a1), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, PlanBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/search".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public PolicyBean createPlanPolicy(final String a0, final String a1, final String a2, final PolicyBean a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/policies".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "createPlanPolicy";
            }
            public Class getReturnType() {
              return PolicyBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId}/versions/{version}/policies)";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}/versions/{version}/policies";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a3), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PolicyBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/policies".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public PolicyBean getPlanPolicy(final String a0, final String a1, final String a2, final long a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)).replace("{policyId}", URL.encodePathSegment(new Long(a3).toString())));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getPlanPolicy";
            }
            public Class getReturnType() {
              return PolicyBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId}/versions/{version}/policies/{policyId})";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}/versions/{version}/policies/{policyId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, PolicyBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])).replace("{policyId}", URL.encodePathSegment(((Long) parameters[3] == null ? "" : (Long) parameters[3]).toString())));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void updatePlanPolicy(final String a0, final String a1, final String a2, final long a3, final PolicyBean a4) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)).replace("{policyId}", URL.encodePathSegment(new Long(a3).toString())));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "updatePlanPolicy";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId}/versions/{version}/policies/{policyId})";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}/versions/{version}/policies/{policyId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a4), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])).replace("{policyId}", URL.encodePathSegment(((Long) parameters[3] == null ? "" : (Long) parameters[3]).toString())));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3, a4 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public void deletePlanPolicy(final String a0, final String a1, final String a2, final long a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)).replace("{policyId}", URL.encodePathSegment(new Long(a3).toString())));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "deletePlanPolicy";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new DELETE() {
                  public Class annotationType() {
                    return DELETE.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.DELETE()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId}/versions/{version}/policies/{policyId})";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}/versions/{version}/policies/{policyId}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/policies/{policyId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])).replace("{policyId}", URL.encodePathSegment(((Long) parameters[3] == null ? "" : (Long) parameters[3]).toString())));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public List listPlanPolicies(final String a0, final String a1, final String a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/policies".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "listPlanPolicies";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId}/versions/{version}/policies)";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}/versions/{version}/policies";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, PolicyBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/policies".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void reorderPlanPolicies(final String a0, final String a1, final String a2, final PolicyChainBean a3) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/reorderPolicies".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{planId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{version}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "reorderPlanPolicies";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/plans/{planId}/versions/{version}/reorderPolicies)";
                  }
                  public String value() {
                    return "{organizationId}/plans/{planId}/versions/{version}/reorderPolicies";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a3), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/plans/{planId}/versions/{version}/reorderPolicies".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{planId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{version}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2, a3 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public void grant(final String a0, final GrantRolesBean a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/roles".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "grant";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/roles)";
                  }
                  public String value() {
                    return "{organizationId}/roles";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a1), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/roles".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public void revoke(final String a0, final String a1, final String a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/roles/{roleId}/{userId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{roleId}", URL.encodePathSegment(a1 == null ? "" : a1)).replace("{userId}", URL.encodePathSegment(a2 == null ? "" : a2)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "revoke";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new DELETE() {
                  public Class annotationType() {
                    return DELETE.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.DELETE()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/roles/{roleId}/{userId})";
                  }
                  public String value() {
                    return "{organizationId}/roles/{roleId}/{userId}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/roles/{roleId}/{userId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{roleId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])).replace("{userId}", URL.encodePathSegment((String) parameters[2] == null ? "" : (String) parameters[2])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public void revokeAll(final String a0, final String a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/members/{userId}".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)).replace("{userId}", URL.encodePathSegment(a1 == null ? "" : a1)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "revokeAll";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new DELETE() {
                  public Class annotationType() {
                    return DELETE.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.DELETE()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/members/{userId})";
                  }
                  public String value() {
                    return "{organizationId}/members/{userId}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/members/{userId}".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])).replace("{userId}", URL.encodePathSegment((String) parameters[1] == null ? "" : (String) parameters[1])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url.toString());
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public List listMembers(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("organizations/{organizationId}/members".replace("{organizationId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "listMembers";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={organizationId}/members)";
                  }
                  public String value() {
                    return "{organizationId}/members";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, MemberBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("organizations/{organizationId}/members".replace("{organizationId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IOrganizationResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }
    }
    RemoteServiceProxyFactory.addRemoteProxy(IOrganizationResource.class, new ProxyProvider() {
      public Object getProxy() {
        return new io_apiman_manager_api_rest_contract_IOrganizationResourceImpl();
      }
    });
    class io_apiman_manager_api_rest_contract_ISearchResourceImpl extends AbstractJaxrsProxy implements ISearchResource {
      private RemoteCallback remoteCallback;
      private ErrorCallback errorCallback;
      public io_apiman_manager_api_rest_contract_ISearchResourceImpl() {
        setExceptionMapper(new RestClientExceptionMapper());
      }

      public RemoteCallback getRemoteCallback() {
        return remoteCallback;
      }

      public void setRemoteCallback(RemoteCallback callback) {
        remoteCallback = callback;
      }

      public ErrorCallback getErrorCallback() {
        return errorCallback;
      }

      public void setErrorCallback(ErrorCallback callback) {
        errorCallback = callback;
      }

      public SearchResultsBean searchOrgs(final SearchCriteriaBean a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("search/organizations");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "searchOrgs";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=organizations)";
                  }
                  public String value() {
                    return "organizations";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=search)";
                  }
                  public String value() {
                    return "search";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a0), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, OrganizationBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("search/organizations");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public SearchResultsBean searchApps(final SearchCriteriaBean a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("search/applications");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "searchApps";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=applications)";
                  }
                  public String value() {
                    return "applications";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=search)";
                  }
                  public String value() {
                    return "search";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a0), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, ApplicationSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("search/applications");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public SearchResultsBean searchServices(final SearchCriteriaBean a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("search/services");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "searchServices";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=services)";
                  }
                  public String value() {
                    return "services";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=search)";
                  }
                  public String value() {
                    return "search";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a0), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, ServiceSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("search/services");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_ISearchResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }
    }
    RemoteServiceProxyFactory.addRemoteProxy(ISearchResource.class, new ProxyProvider() {
      public Object getProxy() {
        return new io_apiman_manager_api_rest_contract_ISearchResourceImpl();
      }
    });
    class io_apiman_manager_api_rest_contract_IPermissionsResourceImpl extends AbstractJaxrsProxy implements IPermissionsResource {
      private RemoteCallback remoteCallback;
      private ErrorCallback errorCallback;
      public io_apiman_manager_api_rest_contract_IPermissionsResourceImpl() {
        setExceptionMapper(new RestClientExceptionMapper());
      }

      public RemoteCallback getRemoteCallback() {
        return remoteCallback;
      }

      public void setRemoteCallback(RemoteCallback callback) {
        remoteCallback = callback;
      }

      public ErrorCallback getErrorCallback() {
        return errorCallback;
      }

      public void setErrorCallback(ErrorCallback callback) {
        errorCallback = callback;
      }

      public UserPermissionsBean getPermissionsForUser(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("permissions/{userId}".replace("{userId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        sendRequest(requestBuilder, null, new ResponseDemarshallingCallback() {
          public Object demarshallResponse(String response) {
            return MarshallingWrapper.fromJSON(response, UserPermissionsBean.class, null);
          }
        });
        return null;
      }

      public UserPermissionsBean getPermissionsForCurrentUser() {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("permissions");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        sendRequest(requestBuilder, null, new ResponseDemarshallingCallback() {
          public Object demarshallResponse(String response) {
            return MarshallingWrapper.fromJSON(response, UserPermissionsBean.class, null);
          }
        });
        return null;
      }
    }
    RemoteServiceProxyFactory.addRemoteProxy(IPermissionsResource.class, new ProxyProvider() {
      public Object getProxy() {
        return new io_apiman_manager_api_rest_contract_IPermissionsResourceImpl();
      }
    });
    class io_apiman_manager_api_rest_contract_IUserResourceImpl extends AbstractJaxrsProxy implements IUserResource {
      private RemoteCallback remoteCallback;
      private ErrorCallback errorCallback;
      public io_apiman_manager_api_rest_contract_IUserResourceImpl() {
        setExceptionMapper(new RestClientExceptionMapper());
      }

      public RemoteCallback getRemoteCallback() {
        return remoteCallback;
      }

      public void setRemoteCallback(RemoteCallback callback) {
        remoteCallback = callback;
      }

      public ErrorCallback getErrorCallback() {
        return errorCallback;
      }

      public void setErrorCallback(ErrorCallback callback) {
        errorCallback = callback;
      }

      public UserBean get(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("users/{userId}".replace("{userId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "get";
            }
            public Class getReturnType() {
              return UserBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={userId})";
                  }
                  public String value() {
                    return "{userId}";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=users)";
                  }
                  public String value() {
                    return "users";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IUserResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, UserBean.class, null);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("users/{userId}".replace("{userId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IUserResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public void update(final String a0, final UserBean a1) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("users/{userId}".replace("{userId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "update";
            }
            public Class getReturnType() {
              return void.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new PUT() {
                  public Class annotationType() {
                    return PUT.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.PUT()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={userId})";
                  }
                  public String value() {
                    return "{userId}";
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=users)";
                  }
                  public String value() {
                    return "users";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IUserResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a1), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return null;
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("users/{userId}".replace("{userId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.PUT, url.toString());
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IUserResourceImpl.this.handleError(throwable, null, null);
        }
      }

      public SearchResultsBean search(final SearchCriteriaBean a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("users/search");
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        requestBuilder.setHeader("Content-Type", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "search";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new Consumes() {
                  public Class annotationType() {
                    return Consumes.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Consumes(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
                }, new POST() {
                  public Class annotationType() {
                    return POST.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.POST()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=search)";
                  }
                  public String value() {
                    return "search";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=users)";
                  }
                  public String value() {
                    return "users";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IUserResourceImpl.this.sendRequest(getRequestBuilder(), MarshallingWrapper.toJSON(a0), new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, UserBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("users/search");
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              requestBuilder.setHeader("Content-Type", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IUserResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List getOrganizations(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("users/{userId}/organizations".replace("{userId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getOrganizations";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={userId}/organizations)";
                  }
                  public String value() {
                    return "{userId}/organizations";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=users)";
                  }
                  public String value() {
                    return "users";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IUserResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, OrganizationSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("users/{userId}/organizations".replace("{userId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IUserResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List getApplications(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("users/{userId}/applications".replace("{userId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getApplications";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={userId}/applications)";
                  }
                  public String value() {
                    return "{userId}/applications";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=users)";
                  }
                  public String value() {
                    return "users";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IUserResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, ApplicationSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("users/{userId}/applications".replace("{userId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IUserResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public List getServices(final String a0) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("users/{userId}/services".replace("{userId}", URL.encodePathSegment(a0 == null ? "" : a0)));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getServices";
            }
            public Class getReturnType() {
              return List.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={userId}/services)";
                  }
                  public String value() {
                    return "{userId}/services";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=users)";
                  }
                  public String value() {
                    return "users";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IUserResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, List.class, ServiceSummaryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("users/{userId}/services".replace("{userId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0])));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IUserResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }

      public SearchResultsBean getActivity(final String a0, final int a1, final int a2) {
        StringBuilder url = new StringBuilder(getBaseUrl());
        url.append("users/{userId}/activity".replace("{userId}", URL.encodePathSegment(a0 == null ? "" : a0))).append("?").append("count").append("=").append(URL.encodeQueryString(new Integer(a2).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(new Integer(a1).toString()));
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
        requestBuilder.setHeader("Accept", "application/json");
        try {
          final CallContextStatus status = new CallContextStatus(AuthInterceptor.class);
          final RestCallContext callContext = new RestCallContext() {
            public String getMethodName() {
              return "getActivity";
            }
            public Class getReturnType() {
              return SearchResultsBean.class;
            }
            public Annotation[] getAnnotations() {
              return new Annotation[] { new GET() {
                  public Class annotationType() {
                    return GET.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.GET()";
                  }
                }, new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value={userId}/activity)";
                  }
                  public String value() {
                    return "{userId}/activity";
                  }
                }, new Produces() {
                  public Class annotationType() {
                    return Produces.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Produces(value=[application/json])";
                  }
                  public String[] value() {
                    return new String[] { "application/json" };
                  }
              } };
            }
            public Annotation[] getTypeAnnotations() {
              return new Annotation[] { new Path() {
                  public Class annotationType() {
                    return Path.class;
                  }
                  public String toString() {
                    return "@javax.ws.rs.Path(value=users)";
                  }
                  public String value() {
                    return "users";
                  }
              } };
            }
            public Object proceed() {
              status.proceed();
              if (status.getNextInterceptor() != null) {
                if (status.getNextInterceptor() == AuthInterceptor.class) {
                  final RestCallContext ctx = this;
                  final CreationalCallback icc = new CreationalCallback() {
                    public void callback(final Object beanInstance) {
                      status.setProceeding(false);
                      ((AuthInterceptor) beanInstance).aroundInvoke(ctx);
                      if (!status.isProceeding()) {
                        remoteCallback.callback(ctx.getResult());
                      }
                    }
                  };
                  org.jboss.errai.ioc.client.container.IOC.getAsyncBeanManager().lookupBeans(AuthInterceptor.class).iterator().next().getInstance(icc);
                }
              } else {
                io_apiman_manager_api_rest_contract_IUserResourceImpl.this.sendRequest(getRequestBuilder(), null, new ResponseDemarshallingCallback() {
                  public Object demarshallResponse(String response) {
                    return MarshallingWrapper.fromJSON(response, SearchResultsBean.class, AuditEntryBean.class);
                  }
                });
              }
              return null;
            }
            public void proceed(final RemoteCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new RemoteCallback() {
                public void callback(Object response) {
                  RemoteCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback(getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(RemoteCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void proceed(final ResponseCallback interceptorCallback) {
              final RemoteCallback providedCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.remoteCallback;
              remoteCallback = new ResponseCallback() {
                public void callback(Response response) {
                  ResponseCallback intCallback = interceptorCallback;
                  setResult(response);
                  intCallback.callback((Response) getResult());
                  providedCallback.callback(getResult());
                }
              };
              proceed();
            }
            public void proceed(final ResponseCallback interceptorCallback, final ErrorCallback interceptorErrorCallback) {
              final ErrorCallback providedErrorCallback = io_apiman_manager_api_rest_contract_IUserResourceImpl.this.errorCallback;
              errorCallback = new ErrorCallback() {
                public boolean error(Object message, Throwable throwable) {
                  interceptorErrorCallback.error(message, throwable);
                  if (getResult() != null) {
                    remoteCallback.callback(getResult());
                    return false;
                  } else if (providedErrorCallback != null) {
                    return providedErrorCallback.error(message, throwable);
                  }
                  return true;
                }
              };
              proceed(interceptorCallback);
            }
            public void setParameters(Object[] parameters) {
              super.setParameters(parameters);
              StringBuilder url = new StringBuilder(getBaseUrl());
              url.append("users/{userId}/activity".replace("{userId}", URL.encodePathSegment((String) parameters[0] == null ? "" : (String) parameters[0]))).append("?").append("count").append("=").append(URL.encodeQueryString(((Integer) parameters[2] == null ? "" : (Integer) parameters[2]).toString())).append("&").append("page").append("=").append(URL.encodeQueryString(((Integer) parameters[1] == null ? "" : (Integer) parameters[1]).toString()));
              RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url.toString());
              requestBuilder.setHeader("Accept", "application/json");
              setRequestBuilder(requestBuilder);
            }
          };
          callContext.setRequestBuilder(requestBuilder);
          callContext.setParameters(new Object[] { a0, a1, a2 });
          callContext.proceed();
        } catch (Throwable throwable) {
          io_apiman_manager_api_rest_contract_IUserResourceImpl.this.handleError(throwable, null, null);
        }
        return null;
      }
    }
    RemoteServiceProxyFactory.addRemoteProxy(IUserResource.class, new ProxyProvider() {
      public Object getProxy() {
        return new io_apiman_manager_api_rest_contract_IUserResourceImpl();
      }
    });
  }
}