package org.jboss.errai.marshalling.client.api;

import io.apiman.gateway.engine.policies.config.BasicAuthenticationConfig;
import io.apiman.gateway.engine.policies.config.basicauth.JDBCIdentitySource;
import io.apiman.gateway.engine.policies.config.basicauth.LDAPIdentitySource;
import io.apiman.gateway.engine.policies.config.basicauth.StaticIdentitySource;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_gateway_engine_policies_config_BasicAuthenticationConfig_Impl implements GeneratedMarshaller<BasicAuthenticationConfig> {
  private BasicAuthenticationConfig[] EMPTY_ARRAY = new BasicAuthenticationConfig[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<StaticIdentitySource> io_apiman_gateway_engine_policies_config_basicauth_StaticIdentitySource = null;
  private Marshaller<LDAPIdentitySource> io_apiman_gateway_engine_policies_config_basicauth_LDAPIdentitySource = null;
  private Marshaller<JDBCIdentitySource> io_apiman_gateway_engine_policies_config_basicauth_JDBCIdentitySource = null;
  public BasicAuthenticationConfig[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public BasicAuthenticationConfig demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(BasicAuthenticationConfig.class, objId);
    }
    BasicAuthenticationConfig entity = new BasicAuthenticationConfig();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("realm")) && (!obj.get("realm").isNull())) {
      entity.setRealm(java_lang_String.demarshall(obj.get("realm"), a1));
    }
    if ((obj.containsKey("forwardIdentityHttpHeader")) && (!obj.get("forwardIdentityHttpHeader").isNull())) {
      entity.setForwardIdentityHttpHeader(java_lang_String.demarshall(obj.get("forwardIdentityHttpHeader"), a1));
    }
    if ((obj.containsKey("staticIdentity")) && (!obj.get("staticIdentity").isNull())) {
      entity.setStaticIdentity(io_apiman_gateway_engine_policies_config_basicauth_StaticIdentitySource.demarshall(obj.get("staticIdentity"), a1));
    }
    if ((obj.containsKey("ldapIdentity")) && (!obj.get("ldapIdentity").isNull())) {
      entity.setLdapIdentity(io_apiman_gateway_engine_policies_config_basicauth_LDAPIdentitySource.demarshall(obj.get("ldapIdentity"), a1));
    }
    if ((obj.containsKey("jdbcIdentity")) && (!obj.get("jdbcIdentity").isNull())) {
      entity.setJdbcIdentity(io_apiman_gateway_engine_policies_config_basicauth_JDBCIdentitySource.demarshall(obj.get("jdbcIdentity"), a1));
    }
    return entity;
  }

  public String marshall(BasicAuthenticationConfig a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.gateway.engine.policies.config.BasicAuthenticationConfig\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"realm\":").append(java_lang_String.marshall(a0.getRealm(), a1)).append(",").append("\"forwardIdentityHttpHeader\":").append(java_lang_String.marshall(a0.getForwardIdentityHttpHeader(), a1)).append(",").append("\"staticIdentity\":").append(io_apiman_gateway_engine_policies_config_basicauth_StaticIdentitySource.marshall(a0.getStaticIdentity(), a1)).append(",").append("\"ldapIdentity\":").append(io_apiman_gateway_engine_policies_config_basicauth_LDAPIdentitySource.marshall(a0.getLdapIdentity(), a1)).append(",").append("\"jdbcIdentity\":").append(io_apiman_gateway_engine_policies_config_basicauth_JDBCIdentitySource.marshall(a0.getJdbcIdentity(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_gateway_engine_policies_config_basicauth_StaticIdentitySource == null) {
      io_apiman_gateway_engine_policies_config_basicauth_StaticIdentitySource = Marshalling.getMarshaller(StaticIdentitySource.class);
    }
    if (io_apiman_gateway_engine_policies_config_basicauth_LDAPIdentitySource == null) {
      io_apiman_gateway_engine_policies_config_basicauth_LDAPIdentitySource = Marshalling.getMarshaller(LDAPIdentitySource.class);
    }
    if (io_apiman_gateway_engine_policies_config_basicauth_JDBCIdentitySource == null) {
      io_apiman_gateway_engine_policies_config_basicauth_JDBCIdentitySource = Marshalling.getMarshaller(JDBCIdentitySource.class);
    }
  }
}