package org.jboss.errai.marshalling.client.api;

import io.apiman.gateway.engine.policies.config.IPWhitelistConfig;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_gateway_engine_policies_config_IPWhitelistConfig_Impl implements GeneratedMarshaller<IPWhitelistConfig> {
  private IPWhitelistConfig[] EMPTY_ARRAY = new IPWhitelistConfig[0];
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public IPWhitelistConfig[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public IPWhitelistConfig demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(IPWhitelistConfig.class, objId);
    }
    IPWhitelistConfig entity = new IPWhitelistConfig();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("ipList")) && (!obj.get("ipList").isNull())) {
      a1.setAssumedElementType("java.lang.String");
      entity.setIpList(java_util_Set.demarshall(obj.get("ipList"), a1));
    }
    return entity;
  }

  public String marshall(IPWhitelistConfig a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.gateway.engine.policies.config.IPWhitelistConfig\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"ipList\":").append(java_util_Set.marshall(a0.getIpList(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}