package org.jboss.errai.marshalling.client.api;

import io.apiman.gateway.engine.policies.config.RateLimitingConfig;
import io.apiman.gateway.engine.policies.config.rates.RateLimitingGranularity;
import io.apiman.gateway.engine.policies.config.rates.RateLimitingPeriod;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_gateway_engine_policies_config_RateLimitingConfig_Impl implements GeneratedMarshaller<RateLimitingConfig> {
  private RateLimitingConfig[] EMPTY_ARRAY = new RateLimitingConfig[0];
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  private Marshaller<RateLimitingGranularity> io_apiman_gateway_engine_policies_config_rates_RateLimitingGranularity = null;
  private Marshaller<RateLimitingPeriod> io_apiman_gateway_engine_policies_config_rates_RateLimitingPeriod = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public RateLimitingConfig[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RateLimitingConfig demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RateLimitingConfig.class, objId);
    }
    RateLimitingConfig entity = new RateLimitingConfig();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("limit")) && (!obj.get("limit").isNull())) {
      entity.setLimit(java_lang_Integer.demarshall(obj.get("limit"), a1));
    }
    if ((obj.containsKey("granularity")) && (!obj.get("granularity").isNull())) {
      entity.setGranularity(obj.get("granularity").isObject() != null ? Enum.valueOf(RateLimitingGranularity.class, obj.get("granularity").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("granularity").isString() != null ? Enum.valueOf(RateLimitingGranularity.class, obj.get("granularity").isString().stringValue()) : null);
    }
    if ((obj.containsKey("period")) && (!obj.get("period").isNull())) {
      entity.setPeriod(obj.get("period").isObject() != null ? Enum.valueOf(RateLimitingPeriod.class, obj.get("period").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("period").isString() != null ? Enum.valueOf(RateLimitingPeriod.class, obj.get("period").isString().stringValue()) : null);
    }
    if ((obj.containsKey("userHeader")) && (!obj.get("userHeader").isNull())) {
      entity.setUserHeader(java_lang_String.demarshall(obj.get("userHeader"), a1));
    }
    return entity;
  }

  public String marshall(RateLimitingConfig a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.gateway.engine.policies.config.RateLimitingConfig\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"limit\":").append(java_lang_Integer.marshall(a0.getLimit(), a1)).append(",").append("\"granularity\":").append(a0.getGranularity() != null ? new StringBuilder(64).append("{\"^EncodedType\":\"io.apiman.gateway.engine.policies.config.rates.RateLimitingGranularity\",\"^EnumStringValue\":\"").append(a0.getGranularity().name()).append("\"}") : "null").append(",").append("\"period\":").append(a0.getPeriod() != null ? new StringBuilder(64).append("{\"^EncodedType\":\"io.apiman.gateway.engine.policies.config.rates.RateLimitingPeriod\",\"^EnumStringValue\":\"").append(a0.getPeriod().name()).append("\"}") : "null").append(",").append("\"userHeader\":").append(java_lang_String.marshall(a0.getUserHeader(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_gateway_engine_policies_config_rates_RateLimitingGranularity == null) {
      io_apiman_gateway_engine_policies_config_rates_RateLimitingGranularity = Marshalling.getMarshaller(RateLimitingGranularity.class);
    }
    if (io_apiman_gateway_engine_policies_config_rates_RateLimitingPeriod == null) {
      io_apiman_gateway_engine_policies_config_rates_RateLimitingPeriod = Marshalling.getMarshaller(RateLimitingPeriod.class);
    }
  }
}