package org.jboss.errai.marshalling.client.api;

import io.apiman.gateway.engine.policies.config.basicauth.JDBCIdentitySource;
import io.apiman.gateway.engine.policies.config.basicauth.PasswordHashAlgorithmType;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_gateway_engine_policies_config_basicauth_JDBCIdentitySource_Impl implements GeneratedMarshaller<JDBCIdentitySource> {
  private JDBCIdentitySource[] EMPTY_ARRAY = new JDBCIdentitySource[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<PasswordHashAlgorithmType> io_apiman_gateway_engine_policies_config_basicauth_PasswordHashAlgorithmType = null;
  public JDBCIdentitySource[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public JDBCIdentitySource demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(JDBCIdentitySource.class, objId);
    }
    JDBCIdentitySource entity = new JDBCIdentitySource();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("datasourcePath")) && (!obj.get("datasourcePath").isNull())) {
      entity.setDatasourcePath(java_lang_String.demarshall(obj.get("datasourcePath"), a1));
    }
    if ((obj.containsKey("query")) && (!obj.get("query").isNull())) {
      entity.setQuery(java_lang_String.demarshall(obj.get("query"), a1));
    }
    if ((obj.containsKey("hashAlgorithm")) && (!obj.get("hashAlgorithm").isNull())) {
      entity.setHashAlgorithm(obj.get("hashAlgorithm").isObject() != null ? Enum.valueOf(PasswordHashAlgorithmType.class, obj.get("hashAlgorithm").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("hashAlgorithm").isString() != null ? Enum.valueOf(PasswordHashAlgorithmType.class, obj.get("hashAlgorithm").isString().stringValue()) : null);
    }
    return entity;
  }

  public String marshall(JDBCIdentitySource a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.gateway.engine.policies.config.basicauth.JDBCIdentitySource\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"datasourcePath\":").append(java_lang_String.marshall(a0.getDatasourcePath(), a1)).append(",").append("\"query\":").append(java_lang_String.marshall(a0.getQuery(), a1)).append(",").append("\"hashAlgorithm\":").append(a0.getHashAlgorithm() != null ? new StringBuilder(64).append("{\"^EncodedType\":\"io.apiman.gateway.engine.policies.config.basicauth.PasswordHashAlgorithmType\",\"^EnumStringValue\":\"").append(a0.getHashAlgorithm().name()).append("\"}") : "null").append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_gateway_engine_policies_config_basicauth_PasswordHashAlgorithmType == null) {
      io_apiman_gateway_engine_policies_config_basicauth_PasswordHashAlgorithmType = Marshalling.getMarshaller(PasswordHashAlgorithmType.class);
    }
  }
}