package org.jboss.errai.marshalling.client.api;

import io.apiman.gateway.engine.policies.config.basicauth.LDAPIdentitySource;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_gateway_engine_policies_config_basicauth_LDAPIdentitySource_Impl implements GeneratedMarshaller<LDAPIdentitySource> {
  private LDAPIdentitySource[] EMPTY_ARRAY = new LDAPIdentitySource[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public LDAPIdentitySource[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public LDAPIdentitySource demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(LDAPIdentitySource.class, objId);
    }
    LDAPIdentitySource entity = new LDAPIdentitySource();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("url")) && (!obj.get("url").isNull())) {
      entity.setUrl(java_lang_String.demarshall(obj.get("url"), a1));
    }
    if ((obj.containsKey("dnPattern")) && (!obj.get("dnPattern").isNull())) {
      entity.setDnPattern(java_lang_String.demarshall(obj.get("dnPattern"), a1));
    }
    return entity;
  }

  public String marshall(LDAPIdentitySource a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.gateway.engine.policies.config.basicauth.LDAPIdentitySource\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"url\":").append(java_lang_String.marshall(a0.getUrl(), a1)).append(",").append("\"dnPattern\":").append(java_lang_String.marshall(a0.getDnPattern(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}