package org.jboss.errai.marshalling.client.api;

import io.apiman.gateway.engine.policies.config.basicauth.StaticIdentitySource;
import java.util.List;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_gateway_engine_policies_config_basicauth_StaticIdentitySource_Impl implements GeneratedMarshaller<StaticIdentitySource> {
  private StaticIdentitySource[] EMPTY_ARRAY = new StaticIdentitySource[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public StaticIdentitySource[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public StaticIdentitySource demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(StaticIdentitySource.class, objId);
    }
    StaticIdentitySource entity = new StaticIdentitySource();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("identities")) && (!obj.get("identities").isNull())) {
      a1.setAssumedElementType("io.apiman.gateway.engine.policies.config.basicauth.StaticIdentity");
      entity.setIdentities(java_util_List.demarshall(obj.get("identities"), a1));
    }
    return entity;
  }

  public String marshall(StaticIdentitySource a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.gateway.engine.policies.config.basicauth.StaticIdentitySource\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"identities\":").append(java_util_List.marshall(a0.getIdentities(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}