package org.jboss.errai.marshalling.client.api;

import io.apiman.gateway.engine.policies.config.basicauth.StaticIdentity;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_gateway_engine_policies_config_basicauth_StaticIdentity_Impl implements GeneratedMarshaller<StaticIdentity> {
  private StaticIdentity[] EMPTY_ARRAY = new StaticIdentity[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public StaticIdentity[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public StaticIdentity demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(StaticIdentity.class, objId);
    }
    StaticIdentity entity = new StaticIdentity();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("username")) && (!obj.get("username").isNull())) {
      entity.setUsername(java_lang_String.demarshall(obj.get("username"), a1));
    }
    if ((obj.containsKey("password")) && (!obj.get("password").isNull())) {
      entity.setPassword(java_lang_String.demarshall(obj.get("password"), a1));
    }
    if ((obj.containsKey("isHash")) && (!obj.get("isHash").isNull())) {
      entity.setIsHash(java_lang_Boolean.demarshall(obj.get("isHash"), a1));
    }
    return entity;
  }

  public String marshall(StaticIdentity a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.gateway.engine.policies.config.basicauth.StaticIdentity\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"username\":").append(java_lang_String.marshall(a0.getUsername(), a1)).append(",").append("\"password\":").append(java_lang_String.marshall(a0.getPassword(), a1)).append(",").append("\"isHash\":").append(java_lang_Boolean.marshall(a0.getIsHash(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}