package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.actions.ActionBean;
import io.apiman.manager.api.beans.actions.ActionType;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_actions_ActionBean_Impl implements GeneratedMarshaller<ActionBean> {
  private ActionBean[] EMPTY_ARRAY = new ActionBean[0];
  private Marshaller<ActionType> io_apiman_manager_api_beans_actions_ActionType = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public ActionBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ActionBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ActionBean.class, objId);
    }
    ActionBean entity = new ActionBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("type")) && (!obj.get("type").isNull())) {
      entity.setType(obj.get("type").isObject() != null ? Enum.valueOf(ActionType.class, obj.get("type").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("type").isString() != null ? Enum.valueOf(ActionType.class, obj.get("type").isString().stringValue()) : null);
    }
    if ((obj.containsKey("organizationId")) && (!obj.get("organizationId").isNull())) {
      entity.setOrganizationId(java_lang_String.demarshall(obj.get("organizationId"), a1));
    }
    if ((obj.containsKey("entityId")) && (!obj.get("entityId").isNull())) {
      entity.setEntityId(java_lang_String.demarshall(obj.get("entityId"), a1));
    }
    if ((obj.containsKey("entityVersion")) && (!obj.get("entityVersion").isNull())) {
      entity.setEntityVersion(java_lang_String.demarshall(obj.get("entityVersion"), a1));
    }
    return entity;
  }

  public String marshall(ActionBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.actions.ActionBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"type\":").append(a0.getType() != null ? new StringBuilder(64).append("{\"^EncodedType\":\"io.apiman.manager.api.beans.actions.ActionType\",\"^EnumStringValue\":\"").append(a0.getType().name()).append("\"}") : "null").append(",").append("\"organizationId\":").append(java_lang_String.marshall(a0.getOrganizationId(), a1)).append(",").append("\"entityId\":").append(java_lang_String.marshall(a0.getEntityId(), a1)).append(",").append("\"entityVersion\":").append(java_lang_String.marshall(a0.getEntityVersion(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_manager_api_beans_actions_ActionType == null) {
      io_apiman_manager_api_beans_actions_ActionType = Marshalling.getMarshaller(ActionType.class);
    }
  }
}