package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.apps.ApplicationBean;
import io.apiman.manager.api.beans.apps.ApplicationStatus;
import io.apiman.manager.api.beans.apps.ApplicationVersionBean;
import java.util.Date;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_apps_ApplicationVersionBean_Impl implements GeneratedMarshaller<ApplicationVersionBean> {
  private ApplicationVersionBean[] EMPTY_ARRAY = new ApplicationVersionBean[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<ApplicationBean> io_apiman_manager_api_beans_apps_ApplicationBean = null;
  private Marshaller<ApplicationStatus> io_apiman_manager_api_beans_apps_ApplicationStatus = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  public ApplicationVersionBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ApplicationVersionBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ApplicationVersionBean.class, objId);
    }
    ApplicationVersionBean entity = new ApplicationVersionBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("id")) && (!obj.get("id").isNull())) {
      entity.setId(java_lang_Long.demarshall(obj.get("id"), a1));
    }
    if ((obj.containsKey("application")) && (!obj.get("application").isNull())) {
      entity.setApplication(io_apiman_manager_api_beans_apps_ApplicationBean.demarshall(obj.get("application"), a1));
    }
    if ((obj.containsKey("status")) && (!obj.get("status").isNull())) {
      entity.setStatus(obj.get("status").isObject() != null ? Enum.valueOf(ApplicationStatus.class, obj.get("status").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("status").isString() != null ? Enum.valueOf(ApplicationStatus.class, obj.get("status").isString().stringValue()) : null);
    }
    if ((obj.containsKey("version")) && (!obj.get("version").isNull())) {
      entity.setVersion(java_lang_String.demarshall(obj.get("version"), a1));
    }
    if ((obj.containsKey("createdBy")) && (!obj.get("createdBy").isNull())) {
      entity.setCreatedBy(java_lang_String.demarshall(obj.get("createdBy"), a1));
    }
    if ((obj.containsKey("createdOn")) && (!obj.get("createdOn").isNull())) {
      entity.setCreatedOn(java_util_Date.demarshall(obj.get("createdOn"), a1));
    }
    if ((obj.containsKey("modifiedBy")) && (!obj.get("modifiedBy").isNull())) {
      entity.setModifiedBy(java_lang_String.demarshall(obj.get("modifiedBy"), a1));
    }
    if ((obj.containsKey("modifiedOn")) && (!obj.get("modifiedOn").isNull())) {
      entity.setModifiedOn(java_util_Date.demarshall(obj.get("modifiedOn"), a1));
    }
    if ((obj.containsKey("publishedOn")) && (!obj.get("publishedOn").isNull())) {
      entity.setPublishedOn(java_util_Date.demarshall(obj.get("publishedOn"), a1));
    }
    if ((obj.containsKey("retiredOn")) && (!obj.get("retiredOn").isNull())) {
      entity.setRetiredOn(java_util_Date.demarshall(obj.get("retiredOn"), a1));
    }
    return entity;
  }

  public String marshall(ApplicationVersionBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.apps.ApplicationVersionBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"id\":").append(java_lang_Long.marshall(a0.getId(), a1)).append(",").append("\"application\":").append(io_apiman_manager_api_beans_apps_ApplicationBean.marshall(a0.getApplication(), a1)).append(",").append("\"status\":").append(a0.getStatus() != null ? new StringBuilder(64).append("{\"^EncodedType\":\"io.apiman.manager.api.beans.apps.ApplicationStatus\",\"^EnumStringValue\":\"").append(a0.getStatus().name()).append("\"}") : "null").append(",").append("\"version\":").append(java_lang_String.marshall(a0.getVersion(), a1)).append(",").append("\"createdBy\":").append(java_lang_String.marshall(a0.getCreatedBy(), a1)).append(",").append("\"createdOn\":").append(java_util_Date.marshall(a0.getCreatedOn(), a1)).append(",").append("\"modifiedBy\":").append(java_lang_String.marshall(a0.getModifiedBy(), a1)).append(",").append("\"modifiedOn\":").append(java_util_Date.marshall(a0.getModifiedOn(), a1)).append(",").append("\"publishedOn\":").append(java_util_Date.marshall(a0.getPublishedOn(), a1)).append(",").append("\"retiredOn\":").append(java_util_Date.marshall(a0.getRetiredOn(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_manager_api_beans_apps_ApplicationBean == null) {
      io_apiman_manager_api_beans_apps_ApplicationBean = Marshalling.getMarshaller(ApplicationBean.class);
    }
    if (io_apiman_manager_api_beans_apps_ApplicationStatus == null) {
      io_apiman_manager_api_beans_apps_ApplicationStatus = Marshalling.getMarshaller(ApplicationStatus.class);
    }
  }
}