package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.audit.AuditEntityType;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.audit.AuditEntryType;
import java.util.Date;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_audit_AuditEntryBean_Impl implements GeneratedMarshaller<AuditEntryBean> {
  private AuditEntryBean[] EMPTY_ARRAY = new AuditEntryBean[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<AuditEntityType> io_apiman_manager_api_beans_audit_AuditEntityType = null;
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<AuditEntryType> io_apiman_manager_api_beans_audit_AuditEntryType = null;
  public AuditEntryBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public AuditEntryBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(AuditEntryBean.class, objId);
    }
    AuditEntryBean entity = new AuditEntryBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("id")) && (!obj.get("id").isNull())) {
      entity.setId(java_lang_Long.demarshall(obj.get("id"), a1));
    }
    if ((obj.containsKey("who")) && (!obj.get("who").isNull())) {
      entity.setWho(java_lang_String.demarshall(obj.get("who"), a1));
    }
    if ((obj.containsKey("organizationId")) && (!obj.get("organizationId").isNull())) {
      entity.setOrganizationId(java_lang_String.demarshall(obj.get("organizationId"), a1));
    }
    if ((obj.containsKey("entityType")) && (!obj.get("entityType").isNull())) {
      entity.setEntityType(obj.get("entityType").isObject() != null ? Enum.valueOf(AuditEntityType.class, obj.get("entityType").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("entityType").isString() != null ? Enum.valueOf(AuditEntityType.class, obj.get("entityType").isString().stringValue()) : null);
    }
    if ((obj.containsKey("entityId")) && (!obj.get("entityId").isNull())) {
      entity.setEntityId(java_lang_String.demarshall(obj.get("entityId"), a1));
    }
    if ((obj.containsKey("entityVersion")) && (!obj.get("entityVersion").isNull())) {
      entity.setEntityVersion(java_lang_String.demarshall(obj.get("entityVersion"), a1));
    }
    if ((obj.containsKey("when")) && (!obj.get("when").isNull())) {
      entity.setWhen(java_util_Date.demarshall(obj.get("when"), a1));
    }
    if ((obj.containsKey("what")) && (!obj.get("what").isNull())) {
      entity.setWhat(obj.get("what").isObject() != null ? Enum.valueOf(AuditEntryType.class, obj.get("what").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("what").isString() != null ? Enum.valueOf(AuditEntryType.class, obj.get("what").isString().stringValue()) : null);
    }
    if ((obj.containsKey("data")) && (!obj.get("data").isNull())) {
      entity.setData(java_lang_String.demarshall(obj.get("data"), a1));
    }
    return entity;
  }

  public String marshall(AuditEntryBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.audit.AuditEntryBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"id\":").append(java_lang_Long.marshall(a0.getId(), a1)).append(",").append("\"who\":").append(java_lang_String.marshall(a0.getWho(), a1)).append(",").append("\"organizationId\":").append(java_lang_String.marshall(a0.getOrganizationId(), a1)).append(",").append("\"entityType\":").append(a0.getEntityType() != null ? new StringBuilder(64).append("{\"^EncodedType\":\"io.apiman.manager.api.beans.audit.AuditEntityType\",\"^EnumStringValue\":\"").append(a0.getEntityType().name()).append("\"}") : "null").append(",").append("\"entityId\":").append(java_lang_String.marshall(a0.getEntityId(), a1)).append(",").append("\"entityVersion\":").append(java_lang_String.marshall(a0.getEntityVersion(), a1)).append(",").append("\"when\":").append(java_util_Date.marshall(a0.getWhen(), a1)).append(",").append("\"what\":").append(a0.getWhat() != null ? new StringBuilder(64).append("{\"^EncodedType\":\"io.apiman.manager.api.beans.audit.AuditEntryType\",\"^EnumStringValue\":\"").append(a0.getWhat().name()).append("\"}") : "null").append(",").append("\"data\":").append(java_lang_String.marshall(a0.getData(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_manager_api_beans_audit_AuditEntityType == null) {
      io_apiman_manager_api_beans_audit_AuditEntityType = Marshalling.getMarshaller(AuditEntityType.class);
    }
    if (io_apiman_manager_api_beans_audit_AuditEntryType == null) {
      io_apiman_manager_api_beans_audit_AuditEntryType = Marshalling.getMarshaller(AuditEntryType.class);
    }
  }
}