package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.audit.data.ContractData;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_audit_data_ContractData_Impl implements GeneratedMarshaller<ContractData> {
  private ContractData[] EMPTY_ARRAY = new ContractData[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public ContractData[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ContractData demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ContractData.class, objId);
    }
    ContractData entity = new ContractData();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("appOrgId")) && (!obj.get("appOrgId").isNull())) {
      entity.setAppOrgId(java_lang_String.demarshall(obj.get("appOrgId"), a1));
    }
    if ((obj.containsKey("appId")) && (!obj.get("appId").isNull())) {
      entity.setAppId(java_lang_String.demarshall(obj.get("appId"), a1));
    }
    if ((obj.containsKey("appVersion")) && (!obj.get("appVersion").isNull())) {
      entity.setAppVersion(java_lang_String.demarshall(obj.get("appVersion"), a1));
    }
    if ((obj.containsKey("serviceOrgId")) && (!obj.get("serviceOrgId").isNull())) {
      entity.setServiceOrgId(java_lang_String.demarshall(obj.get("serviceOrgId"), a1));
    }
    if ((obj.containsKey("serviceId")) && (!obj.get("serviceId").isNull())) {
      entity.setServiceId(java_lang_String.demarshall(obj.get("serviceId"), a1));
    }
    if ((obj.containsKey("serviceVersion")) && (!obj.get("serviceVersion").isNull())) {
      entity.setServiceVersion(java_lang_String.demarshall(obj.get("serviceVersion"), a1));
    }
    if ((obj.containsKey("planId")) && (!obj.get("planId").isNull())) {
      entity.setPlanId(java_lang_String.demarshall(obj.get("planId"), a1));
    }
    if ((obj.containsKey("planVersion")) && (!obj.get("planVersion").isNull())) {
      entity.setPlanVersion(java_lang_String.demarshall(obj.get("planVersion"), a1));
    }
    return entity;
  }

  public String marshall(ContractData a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.audit.data.ContractData\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"appOrgId\":").append(java_lang_String.marshall(a0.getAppOrgId(), a1)).append(",").append("\"appId\":").append(java_lang_String.marshall(a0.getAppId(), a1)).append(",").append("\"appVersion\":").append(java_lang_String.marshall(a0.getAppVersion(), a1)).append(",").append("\"serviceOrgId\":").append(java_lang_String.marshall(a0.getServiceOrgId(), a1)).append(",").append("\"serviceId\":").append(java_lang_String.marshall(a0.getServiceId(), a1)).append(",").append("\"serviceVersion\":").append(java_lang_String.marshall(a0.getServiceVersion(), a1)).append(",").append("\"planId\":").append(java_lang_String.marshall(a0.getPlanId(), a1)).append(",").append("\"planVersion\":").append(java_lang_String.marshall(a0.getPlanVersion(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}