package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.audit.data.EntityFieldChange;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_audit_data_EntityFieldChange_Impl implements GeneratedMarshaller<EntityFieldChange> {
  private EntityFieldChange[] EMPTY_ARRAY = new EntityFieldChange[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public EntityFieldChange[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public EntityFieldChange demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(EntityFieldChange.class, objId);
    }
    EntityFieldChange entity = new EntityFieldChange();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("name")) && (!obj.get("name").isNull())) {
      entity.setName(java_lang_String.demarshall(obj.get("name"), a1));
    }
    if ((obj.containsKey("before")) && (!obj.get("before").isNull())) {
      entity.setBefore(java_lang_String.demarshall(obj.get("before"), a1));
    }
    if ((obj.containsKey("after")) && (!obj.get("after").isNull())) {
      entity.setAfter(java_lang_String.demarshall(obj.get("after"), a1));
    }
    return entity;
  }

  public String marshall(EntityFieldChange a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.audit.data.EntityFieldChange\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"name\":").append(java_lang_String.marshall(a0.getName(), a1)).append(",").append("\"before\":").append(java_lang_String.marshall(a0.getBefore(), a1)).append(",").append("\"after\":").append(java_lang_String.marshall(a0.getAfter(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}