package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.audit.data.EntityUpdatedData;
import java.util.List;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_audit_data_EntityUpdatedData_Impl implements GeneratedMarshaller<EntityUpdatedData> {
  private EntityUpdatedData[] EMPTY_ARRAY = new EntityUpdatedData[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public EntityUpdatedData[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public EntityUpdatedData demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(EntityUpdatedData.class, objId);
    }
    EntityUpdatedData entity = new EntityUpdatedData();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("changes")) && (!obj.get("changes").isNull())) {
      a1.setAssumedElementType("io.apiman.manager.api.beans.audit.data.EntityFieldChange");
      entity.setChanges(java_util_List.demarshall(obj.get("changes"), a1));
    }
    return entity;
  }

  public String marshall(EntityUpdatedData a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.audit.data.EntityUpdatedData\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"changes\":").append(java_util_List.marshall(a0.getChanges(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}