package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.audit.data.PolicyData;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_audit_data_PolicyData_Impl implements GeneratedMarshaller<PolicyData> {
  private PolicyData[] EMPTY_ARRAY = new PolicyData[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public PolicyData[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PolicyData demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PolicyData.class, objId);
    }
    PolicyData entity = new PolicyData();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("policyDefId")) && (!obj.get("policyDefId").isNull())) {
      entity.setPolicyDefId(java_lang_String.demarshall(obj.get("policyDefId"), a1));
    }
    return entity;
  }

  public String marshall(PolicyData a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.audit.data.PolicyData\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"policyDefId\":").append(java_lang_String.marshall(a0.getPolicyDefId(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}