package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.apps.ApplicationVersionBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.services.ServiceVersionBean;
import java.util.Date;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_contracts_ContractBean_Impl implements GeneratedMarshaller<ContractBean> {
  private ContractBean[] EMPTY_ARRAY = new ContractBean[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<ApplicationVersionBean> io_apiman_manager_api_beans_apps_ApplicationVersionBean = null;
  private Marshaller<ServiceVersionBean> io_apiman_manager_api_beans_services_ServiceVersionBean = null;
  private Marshaller<PlanVersionBean> io_apiman_manager_api_beans_plans_PlanVersionBean = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  public ContractBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ContractBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ContractBean.class, objId);
    }
    ContractBean entity = new ContractBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("id")) && (!obj.get("id").isNull())) {
      entity.setId(java_lang_Long.demarshall(obj.get("id"), a1));
    }
    if ((obj.containsKey("application")) && (!obj.get("application").isNull())) {
      entity.setApplication(io_apiman_manager_api_beans_apps_ApplicationVersionBean.demarshall(obj.get("application"), a1));
    }
    if ((obj.containsKey("service")) && (!obj.get("service").isNull())) {
      entity.setService(io_apiman_manager_api_beans_services_ServiceVersionBean.demarshall(obj.get("service"), a1));
    }
    if ((obj.containsKey("plan")) && (!obj.get("plan").isNull())) {
      entity.setPlan(io_apiman_manager_api_beans_plans_PlanVersionBean.demarshall(obj.get("plan"), a1));
    }
    if ((obj.containsKey("createdBy")) && (!obj.get("createdBy").isNull())) {
      entity.setCreatedBy(java_lang_String.demarshall(obj.get("createdBy"), a1));
    }
    if ((obj.containsKey("createdOn")) && (!obj.get("createdOn").isNull())) {
      entity.setCreatedOn(java_util_Date.demarshall(obj.get("createdOn"), a1));
    }
    if ((obj.containsKey("key")) && (!obj.get("key").isNull())) {
      entity.setKey(java_lang_String.demarshall(obj.get("key"), a1));
    }
    return entity;
  }

  public String marshall(ContractBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.contracts.ContractBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"id\":").append(java_lang_Long.marshall(a0.getId(), a1)).append(",").append("\"application\":").append(io_apiman_manager_api_beans_apps_ApplicationVersionBean.marshall(a0.getApplication(), a1)).append(",").append("\"service\":").append(io_apiman_manager_api_beans_services_ServiceVersionBean.marshall(a0.getService(), a1)).append(",").append("\"plan\":").append(io_apiman_manager_api_beans_plans_PlanVersionBean.marshall(a0.getPlan(), a1)).append(",").append("\"createdBy\":").append(java_lang_String.marshall(a0.getCreatedBy(), a1)).append(",").append("\"createdOn\":").append(java_util_Date.marshall(a0.getCreatedOn(), a1)).append(",").append("\"key\":").append(java_lang_String.marshall(a0.getKey(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_manager_api_beans_apps_ApplicationVersionBean == null) {
      io_apiman_manager_api_beans_apps_ApplicationVersionBean = Marshalling.getMarshaller(ApplicationVersionBean.class);
    }
    if (io_apiman_manager_api_beans_services_ServiceVersionBean == null) {
      io_apiman_manager_api_beans_services_ServiceVersionBean = Marshalling.getMarshaller(ServiceVersionBean.class);
    }
    if (io_apiman_manager_api_beans_plans_PlanVersionBean == null) {
      io_apiman_manager_api_beans_plans_PlanVersionBean = Marshalling.getMarshaller(PlanVersionBean.class);
    }
  }
}