package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.contracts.NewContractBean;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_contracts_NewContractBean_Impl implements GeneratedMarshaller<NewContractBean> {
  private NewContractBean[] EMPTY_ARRAY = new NewContractBean[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public NewContractBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public NewContractBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(NewContractBean.class, objId);
    }
    NewContractBean entity = new NewContractBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("serviceOrgId")) && (!obj.get("serviceOrgId").isNull())) {
      entity.setServiceOrgId(java_lang_String.demarshall(obj.get("serviceOrgId"), a1));
    }
    if ((obj.containsKey("serviceId")) && (!obj.get("serviceId").isNull())) {
      entity.setServiceId(java_lang_String.demarshall(obj.get("serviceId"), a1));
    }
    if ((obj.containsKey("serviceVersion")) && (!obj.get("serviceVersion").isNull())) {
      entity.setServiceVersion(java_lang_String.demarshall(obj.get("serviceVersion"), a1));
    }
    if ((obj.containsKey("planId")) && (!obj.get("planId").isNull())) {
      entity.setPlanId(java_lang_String.demarshall(obj.get("planId"), a1));
    }
    return entity;
  }

  public String marshall(NewContractBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.contracts.NewContractBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"serviceOrgId\":").append(java_lang_String.marshall(a0.getServiceOrgId(), a1)).append(",").append("\"serviceId\":").append(java_lang_String.marshall(a0.getServiceId(), a1)).append(",").append("\"serviceVersion\":").append(java_lang_String.marshall(a0.getServiceVersion(), a1)).append(",").append("\"planId\":").append(java_lang_String.marshall(a0.getPlanId(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}