package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.exceptions.ErrorBean;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_exceptions_ErrorBean_Impl implements GeneratedMarshaller<ErrorBean> {
  private ErrorBean[] EMPTY_ARRAY = new ErrorBean[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public ErrorBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ErrorBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ErrorBean.class, objId);
    }
    ErrorBean entity = new ErrorBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("type")) && (!obj.get("type").isNull())) {
      entity.setType(java_lang_String.demarshall(obj.get("type"), a1));
    }
    if ((obj.containsKey("errorCode")) && (!obj.get("errorCode").isNull())) {
      entity.setErrorCode(java_lang_Integer.demarshall(obj.get("errorCode"), a1));
    }
    if ((obj.containsKey("message")) && (!obj.get("message").isNull())) {
      entity.setMessage(java_lang_String.demarshall(obj.get("message"), a1));
    }
    if ((obj.containsKey("moreInfoUrl")) && (!obj.get("moreInfoUrl").isNull())) {
      entity.setMoreInfoUrl(java_lang_String.demarshall(obj.get("moreInfoUrl"), a1));
    }
    if ((obj.containsKey("stacktrace")) && (!obj.get("stacktrace").isNull())) {
      entity.setStacktrace(java_lang_String.demarshall(obj.get("stacktrace"), a1));
    }
    return entity;
  }

  public String marshall(ErrorBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.exceptions.ErrorBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"type\":").append(java_lang_String.marshall(a0.getType(), a1)).append(",").append("\"errorCode\":").append(java_lang_Integer.marshall(a0.getErrorCode(), a1)).append(",").append("\"message\":").append(java_lang_String.marshall(a0.getMessage(), a1)).append(",").append("\"moreInfoUrl\":").append(java_lang_String.marshall(a0.getMoreInfoUrl(), a1)).append(",").append("\"stacktrace\":").append(java_lang_String.marshall(a0.getStacktrace(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}