package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.idm.GrantRolesBean;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_idm_GrantRolesBean_Impl implements GeneratedMarshaller<GrantRolesBean> {
  private GrantRolesBean[] EMPTY_ARRAY = new GrantRolesBean[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public GrantRolesBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public GrantRolesBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(GrantRolesBean.class, objId);
    }
    GrantRolesBean entity = new GrantRolesBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("userId")) && (!obj.get("userId").isNull())) {
      entity.setUserId(java_lang_String.demarshall(obj.get("userId"), a1));
    }
    if ((obj.containsKey("roleIds")) && (!obj.get("roleIds").isNull())) {
      a1.setAssumedElementType("java.lang.String");
      entity.setRoleIds(java_util_Set.demarshall(obj.get("roleIds"), a1));
    }
    return entity;
  }

  public String marshall(GrantRolesBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.idm.GrantRolesBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"userId\":").append(java_lang_String.marshall(a0.getUserId(), a1)).append(",").append("\"roleIds\":").append(java_util_Set.marshall(a0.getRoleIds(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}