package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.idm.PermissionBean;
import io.apiman.manager.api.beans.idm.PermissionType;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_idm_PermissionBean_Impl implements GeneratedMarshaller<PermissionBean> {
  private PermissionBean[] EMPTY_ARRAY = new PermissionBean[0];
  private Marshaller<PermissionType> io_apiman_manager_api_beans_idm_PermissionType = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public PermissionBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PermissionBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PermissionBean.class, objId);
    }
    PermissionBean entity = new PermissionBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("name")) && (!obj.get("name").isNull())) {
      entity.setName(obj.get("name").isObject() != null ? Enum.valueOf(PermissionType.class, obj.get("name").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("name").isString() != null ? Enum.valueOf(PermissionType.class, obj.get("name").isString().stringValue()) : null);
    }
    if ((obj.containsKey("organizationId")) && (!obj.get("organizationId").isNull())) {
      entity.setOrganizationId(java_lang_String.demarshall(obj.get("organizationId"), a1));
    }
    return entity;
  }

  public String marshall(PermissionBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.idm.PermissionBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"name\":").append(a0.getName() != null ? new StringBuilder(64).append("{\"^EncodedType\":\"io.apiman.manager.api.beans.idm.PermissionType\",\"^EnumStringValue\":\"").append(a0.getName().name()).append("\"}") : "null").append(",").append("\"organizationId\":").append(java_lang_String.marshall(a0.getOrganizationId(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_manager_api_beans_idm_PermissionType == null) {
      io_apiman_manager_api_beans_idm_PermissionType = Marshalling.getMarshaller(PermissionType.class);
    }
  }
}