package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.idm.RoleBean;
import java.util.Date;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_idm_RoleBean_Impl implements GeneratedMarshaller<RoleBean> {
  private RoleBean[] EMPTY_ARRAY = new RoleBean[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public RoleBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public RoleBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(RoleBean.class, objId);
    }
    RoleBean entity = new RoleBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("id")) && (!obj.get("id").isNull())) {
      entity.setId(java_lang_String.demarshall(obj.get("id"), a1));
    }
    if ((obj.containsKey("name")) && (!obj.get("name").isNull())) {
      entity.setName(java_lang_String.demarshall(obj.get("name"), a1));
    }
    if ((obj.containsKey("description")) && (!obj.get("description").isNull())) {
      entity.setDescription(java_lang_String.demarshall(obj.get("description"), a1));
    }
    if ((obj.containsKey("createdBy")) && (!obj.get("createdBy").isNull())) {
      entity.setCreatedBy(java_lang_String.demarshall(obj.get("createdBy"), a1));
    }
    if ((obj.containsKey("createdOn")) && (!obj.get("createdOn").isNull())) {
      entity.setCreatedOn(java_util_Date.demarshall(obj.get("createdOn"), a1));
    }
    if ((obj.containsKey("autoGrant")) && (!obj.get("autoGrant").isNull())) {
      entity.setAutoGrant(java_lang_Boolean.demarshall(obj.get("autoGrant"), a1));
    }
    if ((obj.containsKey("permissions")) && (!obj.get("permissions").isNull())) {
      a1.setAssumedElementType("io.apiman.manager.api.beans.idm.PermissionType");
      entity.setPermissions(java_util_Set.demarshall(obj.get("permissions"), a1));
    }
    return entity;
  }

  public String marshall(RoleBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.idm.RoleBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"id\":").append(java_lang_String.marshall(a0.getId(), a1)).append(",").append("\"name\":").append(java_lang_String.marshall(a0.getName(), a1)).append(",").append("\"description\":").append(java_lang_String.marshall(a0.getDescription(), a1)).append(",").append("\"createdBy\":").append(java_lang_String.marshall(a0.getCreatedBy(), a1)).append(",").append("\"createdOn\":").append(java_util_Date.marshall(a0.getCreatedOn(), a1)).append(",").append("\"autoGrant\":").append(java_lang_Boolean.marshall(a0.getAutoGrant(), a1)).append(",").append("\"permissions\":").append(java_util_Set.marshall(a0.getPermissions(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}