package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.idm.UserBean;
import java.util.Date;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_idm_UserBean_Impl implements GeneratedMarshaller<UserBean> {
  private UserBean[] EMPTY_ARRAY = new UserBean[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<Boolean> java_lang_Boolean = Marshalling.getMarshaller(Boolean.class);
  public UserBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public UserBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(UserBean.class, objId);
    }
    UserBean entity = new UserBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("username")) && (!obj.get("username").isNull())) {
      entity.setUsername(java_lang_String.demarshall(obj.get("username"), a1));
    }
    if ((obj.containsKey("fullName")) && (!obj.get("fullName").isNull())) {
      entity.setFullName(java_lang_String.demarshall(obj.get("fullName"), a1));
    }
    if ((obj.containsKey("email")) && (!obj.get("email").isNull())) {
      entity.setEmail(java_lang_String.demarshall(obj.get("email"), a1));
    }
    if ((obj.containsKey("joinedOn")) && (!obj.get("joinedOn").isNull())) {
      entity.setJoinedOn(java_util_Date.demarshall(obj.get("joinedOn"), a1));
    }
    if ((obj.containsKey("admin")) && (!obj.get("admin").isNull())) {
      entity.setAdmin(java_lang_Boolean.demarshall(obj.get("admin"), a1));
    }
    return entity;
  }

  private native static boolean _1171448541__64711720_admin(UserBean instance) /*-{
    return instance.@io.apiman.manager.api.beans.idm.UserBean::admin;
  }-*/;

  private native static void _1171448541__64711720_admin(UserBean instance, boolean value) /*-{
    instance.@io.apiman.manager.api.beans.idm.UserBean::admin = value;
  }-*/;

  public String marshall(UserBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.idm.UserBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"username\":").append(java_lang_String.marshall(a0.getUsername(), a1)).append(",").append("\"fullName\":").append(java_lang_String.marshall(a0.getFullName(), a1)).append(",").append("\"email\":").append(java_lang_String.marshall(a0.getEmail(), a1)).append(",").append("\"joinedOn\":").append(java_util_Date.marshall(a0.getJoinedOn(), a1)).append(",").append("\"admin\":").append(java_lang_Boolean.marshall(_1171448541__64711720_admin(a0), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}