package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.idm.UserPermissionsBean;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_idm_UserPermissionsBean_Impl implements GeneratedMarshaller<UserPermissionsBean> {
  private UserPermissionsBean[] EMPTY_ARRAY = new UserPermissionsBean[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public UserPermissionsBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public UserPermissionsBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(UserPermissionsBean.class, objId);
    }
    UserPermissionsBean entity = new UserPermissionsBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("userId")) && (!obj.get("userId").isNull())) {
      entity.setUserId(java_lang_String.demarshall(obj.get("userId"), a1));
    }
    if ((obj.containsKey("permissions")) && (!obj.get("permissions").isNull())) {
      a1.setAssumedElementType("io.apiman.manager.api.beans.idm.PermissionBean");
      entity.setPermissions(java_util_Set.demarshall(obj.get("permissions"), a1));
    }
    return entity;
  }

  public String marshall(UserPermissionsBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.idm.UserPermissionsBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"userId\":").append(java_lang_String.marshall(a0.getUserId(), a1)).append(",").append("\"permissions\":").append(java_util_Set.marshall(a0.getPermissions(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}