package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.members.MemberBean;
import java.util.Date;
import java.util.List;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_members_MemberBean_Impl implements GeneratedMarshaller<MemberBean> {
  private MemberBean[] EMPTY_ARRAY = new MemberBean[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public MemberBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public MemberBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(MemberBean.class, objId);
    }
    MemberBean entity = new MemberBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("userId")) && (!obj.get("userId").isNull())) {
      entity.setUserId(java_lang_String.demarshall(obj.get("userId"), a1));
    }
    if ((obj.containsKey("userName")) && (!obj.get("userName").isNull())) {
      entity.setUserName(java_lang_String.demarshall(obj.get("userName"), a1));
    }
    if ((obj.containsKey("email")) && (!obj.get("email").isNull())) {
      entity.setEmail(java_lang_String.demarshall(obj.get("email"), a1));
    }
    if ((obj.containsKey("joinedOn")) && (!obj.get("joinedOn").isNull())) {
      entity.setJoinedOn(java_util_Date.demarshall(obj.get("joinedOn"), a1));
    }
    if ((obj.containsKey("roles")) && (!obj.get("roles").isNull())) {
      a1.setAssumedElementType("io.apiman.manager.api.beans.members.MemberRoleBean");
      entity.setRoles(java_util_List.demarshall(obj.get("roles"), a1));
    }
    return entity;
  }

  public String marshall(MemberBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.members.MemberBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"userId\":").append(java_lang_String.marshall(a0.getUserId(), a1)).append(",").append("\"userName\":").append(java_lang_String.marshall(a0.getUserName(), a1)).append(",").append("\"email\":").append(java_lang_String.marshall(a0.getEmail(), a1)).append(",").append("\"joinedOn\":").append(java_util_Date.marshall(a0.getJoinedOn(), a1)).append(",").append("\"roles\":").append(java_util_List.marshall(a0.getRoles(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}