package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.members.MemberRoleBean;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_members_MemberRoleBean_Impl implements GeneratedMarshaller<MemberRoleBean> {
  private MemberRoleBean[] EMPTY_ARRAY = new MemberRoleBean[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public MemberRoleBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public MemberRoleBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(MemberRoleBean.class, objId);
    }
    MemberRoleBean entity = new MemberRoleBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("roleId")) && (!obj.get("roleId").isNull())) {
      entity.setRoleId(java_lang_String.demarshall(obj.get("roleId"), a1));
    }
    if ((obj.containsKey("roleName")) && (!obj.get("roleName").isNull())) {
      entity.setRoleName(java_lang_String.demarshall(obj.get("roleName"), a1));
    }
    return entity;
  }

  public String marshall(MemberRoleBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.members.MemberRoleBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"roleId\":").append(java_lang_String.marshall(a0.getRoleId(), a1)).append(",").append("\"roleName\":").append(java_lang_String.marshall(a0.getRoleName(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}