package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanStatus;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import java.util.Date;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_plans_PlanVersionBean_Impl implements GeneratedMarshaller<PlanVersionBean> {
  private PlanVersionBean[] EMPTY_ARRAY = new PlanVersionBean[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<PlanBean> io_apiman_manager_api_beans_plans_PlanBean = null;
  private Marshaller<PlanStatus> io_apiman_manager_api_beans_plans_PlanStatus = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  public PlanVersionBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PlanVersionBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PlanVersionBean.class, objId);
    }
    PlanVersionBean entity = new PlanVersionBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("id")) && (!obj.get("id").isNull())) {
      entity.setId(java_lang_Long.demarshall(obj.get("id"), a1));
    }
    if ((obj.containsKey("plan")) && (!obj.get("plan").isNull())) {
      entity.setPlan(io_apiman_manager_api_beans_plans_PlanBean.demarshall(obj.get("plan"), a1));
    }
    if ((obj.containsKey("status")) && (!obj.get("status").isNull())) {
      entity.setStatus(obj.get("status").isObject() != null ? Enum.valueOf(PlanStatus.class, obj.get("status").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("status").isString() != null ? Enum.valueOf(PlanStatus.class, obj.get("status").isString().stringValue()) : null);
    }
    if ((obj.containsKey("version")) && (!obj.get("version").isNull())) {
      entity.setVersion(java_lang_String.demarshall(obj.get("version"), a1));
    }
    if ((obj.containsKey("createdBy")) && (!obj.get("createdBy").isNull())) {
      entity.setCreatedBy(java_lang_String.demarshall(obj.get("createdBy"), a1));
    }
    if ((obj.containsKey("createdOn")) && (!obj.get("createdOn").isNull())) {
      entity.setCreatedOn(java_util_Date.demarshall(obj.get("createdOn"), a1));
    }
    if ((obj.containsKey("modifiedBy")) && (!obj.get("modifiedBy").isNull())) {
      entity.setModifiedBy(java_lang_String.demarshall(obj.get("modifiedBy"), a1));
    }
    if ((obj.containsKey("modifiedOn")) && (!obj.get("modifiedOn").isNull())) {
      entity.setModifiedOn(java_util_Date.demarshall(obj.get("modifiedOn"), a1));
    }
    if ((obj.containsKey("lockedOn")) && (!obj.get("lockedOn").isNull())) {
      entity.setLockedOn(java_util_Date.demarshall(obj.get("lockedOn"), a1));
    }
    return entity;
  }

  public String marshall(PlanVersionBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.plans.PlanVersionBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"id\":").append(java_lang_Long.marshall(a0.getId(), a1)).append(",").append("\"plan\":").append(io_apiman_manager_api_beans_plans_PlanBean.marshall(a0.getPlan(), a1)).append(",").append("\"status\":").append(a0.getStatus() != null ? new StringBuilder(64).append("{\"^EncodedType\":\"io.apiman.manager.api.beans.plans.PlanStatus\",\"^EnumStringValue\":\"").append(a0.getStatus().name()).append("\"}") : "null").append(",").append("\"version\":").append(java_lang_String.marshall(a0.getVersion(), a1)).append(",").append("\"createdBy\":").append(java_lang_String.marshall(a0.getCreatedBy(), a1)).append(",").append("\"createdOn\":").append(java_util_Date.marshall(a0.getCreatedOn(), a1)).append(",").append("\"modifiedBy\":").append(java_lang_String.marshall(a0.getModifiedBy(), a1)).append(",").append("\"modifiedOn\":").append(java_util_Date.marshall(a0.getModifiedOn(), a1)).append(",").append("\"lockedOn\":").append(java_util_Date.marshall(a0.getLockedOn(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_manager_api_beans_plans_PlanBean == null) {
      io_apiman_manager_api_beans_plans_PlanBean = Marshalling.getMarshaller(PlanBean.class);
    }
    if (io_apiman_manager_api_beans_plans_PlanStatus == null) {
      io_apiman_manager_api_beans_plans_PlanStatus = Marshalling.getMarshaller(PlanStatus.class);
    }
  }
}