package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import java.util.Date;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_policies_PolicyBean_Impl implements GeneratedMarshaller<PolicyBean> {
  private PolicyBean[] EMPTY_ARRAY = new PolicyBean[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<PolicyType> io_apiman_manager_api_beans_policies_PolicyType = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  private Marshaller<PolicyDefinitionBean> io_apiman_manager_api_beans_policies_PolicyDefinitionBean = null;
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public PolicyBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PolicyBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PolicyBean.class, objId);
    }
    PolicyBean entity = new PolicyBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("id")) && (!obj.get("id").isNull())) {
      entity.setId(java_lang_Long.demarshall(obj.get("id"), a1));
    }
    if ((obj.containsKey("type")) && (!obj.get("type").isNull())) {
      entity.setType(obj.get("type").isObject() != null ? Enum.valueOf(PolicyType.class, obj.get("type").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("type").isString() != null ? Enum.valueOf(PolicyType.class, obj.get("type").isString().stringValue()) : null);
    }
    if ((obj.containsKey("organizationId")) && (!obj.get("organizationId").isNull())) {
      entity.setOrganizationId(java_lang_String.demarshall(obj.get("organizationId"), a1));
    }
    if ((obj.containsKey("entityId")) && (!obj.get("entityId").isNull())) {
      entity.setEntityId(java_lang_String.demarshall(obj.get("entityId"), a1));
    }
    if ((obj.containsKey("entityVersion")) && (!obj.get("entityVersion").isNull())) {
      entity.setEntityVersion(java_lang_String.demarshall(obj.get("entityVersion"), a1));
    }
    if ((obj.containsKey("name")) && (!obj.get("name").isNull())) {
      entity.setName(java_lang_String.demarshall(obj.get("name"), a1));
    }
    if ((obj.containsKey("description")) && (!obj.get("description").isNull())) {
      entity.setDescription(java_lang_String.demarshall(obj.get("description"), a1));
    }
    if ((obj.containsKey("configuration")) && (!obj.get("configuration").isNull())) {
      entity.setConfiguration(java_lang_String.demarshall(obj.get("configuration"), a1));
    }
    if ((obj.containsKey("createdBy")) && (!obj.get("createdBy").isNull())) {
      entity.setCreatedBy(java_lang_String.demarshall(obj.get("createdBy"), a1));
    }
    if ((obj.containsKey("createdOn")) && (!obj.get("createdOn").isNull())) {
      entity.setCreatedOn(java_util_Date.demarshall(obj.get("createdOn"), a1));
    }
    if ((obj.containsKey("modifiedBy")) && (!obj.get("modifiedBy").isNull())) {
      entity.setModifiedBy(java_lang_String.demarshall(obj.get("modifiedBy"), a1));
    }
    if ((obj.containsKey("modifiedOn")) && (!obj.get("modifiedOn").isNull())) {
      entity.setModifiedOn(java_util_Date.demarshall(obj.get("modifiedOn"), a1));
    }
    if ((obj.containsKey("definition")) && (!obj.get("definition").isNull())) {
      entity.setDefinition(io_apiman_manager_api_beans_policies_PolicyDefinitionBean.demarshall(obj.get("definition"), a1));
    }
    if ((obj.containsKey("orderIndex")) && (!obj.get("orderIndex").isNull())) {
      entity.setOrderIndex(java_lang_Integer.demarshall(obj.get("orderIndex"), a1));
    }
    return entity;
  }

  public String marshall(PolicyBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.policies.PolicyBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"id\":").append(java_lang_Long.marshall(a0.getId(), a1)).append(",").append("\"type\":").append(a0.getType() != null ? new StringBuilder(64).append("{\"^EncodedType\":\"io.apiman.manager.api.beans.policies.PolicyType\",\"^EnumStringValue\":\"").append(a0.getType().name()).append("\"}") : "null").append(",").append("\"organizationId\":").append(java_lang_String.marshall(a0.getOrganizationId(), a1)).append(",").append("\"entityId\":").append(java_lang_String.marshall(a0.getEntityId(), a1)).append(",").append("\"entityVersion\":").append(java_lang_String.marshall(a0.getEntityVersion(), a1)).append(",").append("\"name\":").append(java_lang_String.marshall(a0.getName(), a1)).append(",").append("\"description\":").append(java_lang_String.marshall(a0.getDescription(), a1)).append(",").append("\"configuration\":").append(java_lang_String.marshall(a0.getConfiguration(), a1)).append(",").append("\"createdBy\":").append(java_lang_String.marshall(a0.getCreatedBy(), a1)).append(",").append("\"createdOn\":").append(java_util_Date.marshall(a0.getCreatedOn(), a1)).append(",").append("\"modifiedBy\":").append(java_lang_String.marshall(a0.getModifiedBy(), a1)).append(",").append("\"modifiedOn\":").append(java_util_Date.marshall(a0.getModifiedOn(), a1)).append(",").append("\"definition\":").append(io_apiman_manager_api_beans_policies_PolicyDefinitionBean.marshall(a0.getDefinition(), a1)).append(",").append("\"orderIndex\":").append(java_lang_Integer.marshall(a0.getOrderIndex(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_manager_api_beans_policies_PolicyType == null) {
      io_apiman_manager_api_beans_policies_PolicyType = Marshalling.getMarshaller(PolicyType.class);
    }
    if (io_apiman_manager_api_beans_policies_PolicyDefinitionBean == null) {
      io_apiman_manager_api_beans_policies_PolicyDefinitionBean = Marshalling.getMarshaller(PolicyDefinitionBean.class);
    }
  }
}