package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.policies.PolicyChainBean;
import java.util.List;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_policies_PolicyChainBean_Impl implements GeneratedMarshaller<PolicyChainBean> {
  private PolicyChainBean[] EMPTY_ARRAY = new PolicyChainBean[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  public PolicyChainBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PolicyChainBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PolicyChainBean.class, objId);
    }
    PolicyChainBean entity = new PolicyChainBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("policies")) && (!obj.get("policies").isNull())) {
      a1.setAssumedElementType("io.apiman.manager.api.beans.policies.PolicyBean");
      entity.setPolicies(java_util_List.demarshall(obj.get("policies"), a1));
    }
    return entity;
  }

  public String marshall(PolicyChainBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.policies.PolicyChainBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"policies\":").append(java_util_List.marshall(a0.getPolicies(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}