package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_policies_PolicyDefinitionBean_Impl implements GeneratedMarshaller<PolicyDefinitionBean> {
  private PolicyDefinitionBean[] EMPTY_ARRAY = new PolicyDefinitionBean[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  public PolicyDefinitionBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PolicyDefinitionBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PolicyDefinitionBean.class, objId);
    }
    PolicyDefinitionBean entity = new PolicyDefinitionBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("id")) && (!obj.get("id").isNull())) {
      entity.setId(java_lang_String.demarshall(obj.get("id"), a1));
    }
    if ((obj.containsKey("policyImpl")) && (!obj.get("policyImpl").isNull())) {
      entity.setPolicyImpl(java_lang_String.demarshall(obj.get("policyImpl"), a1));
    }
    if ((obj.containsKey("name")) && (!obj.get("name").isNull())) {
      entity.setName(java_lang_String.demarshall(obj.get("name"), a1));
    }
    if ((obj.containsKey("description")) && (!obj.get("description").isNull())) {
      entity.setDescription(java_lang_String.demarshall(obj.get("description"), a1));
    }
    if ((obj.containsKey("icon")) && (!obj.get("icon").isNull())) {
      entity.setIcon(java_lang_String.demarshall(obj.get("icon"), a1));
    }
    if ((obj.containsKey("templates")) && (!obj.get("templates").isNull())) {
      a1.setAssumedElementType("io.apiman.manager.api.beans.policies.PolicyDefinitionTemplateBean");
      entity.setTemplates(java_util_Set.demarshall(obj.get("templates"), a1));
    }
    return entity;
  }

  public String marshall(PolicyDefinitionBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.policies.PolicyDefinitionBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"id\":").append(java_lang_String.marshall(a0.getId(), a1)).append(",").append("\"policyImpl\":").append(java_lang_String.marshall(a0.getPolicyImpl(), a1)).append(",").append("\"name\":").append(java_lang_String.marshall(a0.getName(), a1)).append(",").append("\"description\":").append(java_lang_String.marshall(a0.getDescription(), a1)).append(",").append("\"icon\":").append(java_lang_String.marshall(a0.getIcon(), a1)).append(",").append("\"templates\":").append(java_util_Set.marshall(a0.getTemplates(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}