package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.search.PagingBean;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_search_PagingBean_Impl implements GeneratedMarshaller<PagingBean> {
  private PagingBean[] EMPTY_ARRAY = new PagingBean[0];
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public PagingBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public PagingBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(PagingBean.class, objId);
    }
    PagingBean entity = new PagingBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("page")) && (!obj.get("page").isNull())) {
      entity.setPage(java_lang_Integer.demarshall(obj.get("page"), a1));
    }
    if ((obj.containsKey("pageSize")) && (!obj.get("pageSize").isNull())) {
      entity.setPageSize(java_lang_Integer.demarshall(obj.get("pageSize"), a1));
    }
    return entity;
  }

  public String marshall(PagingBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.search.PagingBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"page\":").append(java_lang_Integer.marshall(a0.getPage(), a1)).append(",").append("\"pageSize\":").append(java_lang_Integer.marshall(a0.getPageSize(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}