package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.search.OrderByBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import java.util.List;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_search_SearchCriteriaBean_Impl implements GeneratedMarshaller<SearchCriteriaBean> {
  private SearchCriteriaBean[] EMPTY_ARRAY = new SearchCriteriaBean[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<OrderByBean> io_apiman_manager_api_beans_search_OrderByBean = null;
  private Marshaller<PagingBean> io_apiman_manager_api_beans_search_PagingBean = null;
  public SearchCriteriaBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public SearchCriteriaBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(SearchCriteriaBean.class, objId);
    }
    SearchCriteriaBean entity = new SearchCriteriaBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("filters")) && (!obj.get("filters").isNull())) {
      a1.setAssumedElementType("io.apiman.manager.api.beans.search.SearchCriteriaFilterBean");
      entity.setFilters(java_util_List.demarshall(obj.get("filters"), a1));
    }
    if ((obj.containsKey("orderBy")) && (!obj.get("orderBy").isNull())) {
      entity.setOrderBy(io_apiman_manager_api_beans_search_OrderByBean.demarshall(obj.get("orderBy"), a1));
    }
    if ((obj.containsKey("paging")) && (!obj.get("paging").isNull())) {
      entity.setPaging(io_apiman_manager_api_beans_search_PagingBean.demarshall(obj.get("paging"), a1));
    }
    return entity;
  }

  public String marshall(SearchCriteriaBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.search.SearchCriteriaBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"filters\":").append(java_util_List.marshall(a0.getFilters(), a1)).append(",").append("\"orderBy\":").append(io_apiman_manager_api_beans_search_OrderByBean.marshall(a0.getOrderBy(), a1)).append(",").append("\"paging\":").append(io_apiman_manager_api_beans_search_PagingBean.marshall(a0.getPaging(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_manager_api_beans_search_OrderByBean == null) {
      io_apiman_manager_api_beans_search_OrderByBean = Marshalling.getMarshaller(OrderByBean.class);
    }
    if (io_apiman_manager_api_beans_search_PagingBean == null) {
      io_apiman_manager_api_beans_search_PagingBean = Marshalling.getMarshaller(PagingBean.class);
    }
  }
}