package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.search.SearchResultsBean;
import java.util.List;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_search_SearchResultsBean_Impl implements GeneratedMarshaller<SearchResultsBean> {
  private SearchResultsBean[] EMPTY_ARRAY = new SearchResultsBean[0];
  private Marshaller<List> java_util_List = Marshalling.getMarshaller(List.class);
  private Marshaller<Integer> java_lang_Integer = Marshalling.getMarshaller(Integer.class);
  public SearchResultsBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public SearchResultsBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(SearchResultsBean.class, objId);
    }
    SearchResultsBean entity = new SearchResultsBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("beans")) && (!obj.get("beans").isNull())) {
      entity.setBeans(java_util_List.demarshall(obj.get("beans"), a1));
    }
    if ((obj.containsKey("totalSize")) && (!obj.get("totalSize").isNull())) {
      entity.setTotalSize(java_lang_Integer.demarshall(obj.get("totalSize"), a1));
    }
    return entity;
  }

  public String marshall(SearchResultsBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.search.SearchResultsBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"beans\":").append(java_util_List.marshall(a0.getBeans(), a1)).append(",").append("\"totalSize\":").append(java_lang_Integer.marshall(a0.getTotalSize(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}