package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.services.ServicePlanBean;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_services_ServicePlanBean_Impl implements GeneratedMarshaller<ServicePlanBean> {
  private ServicePlanBean[] EMPTY_ARRAY = new ServicePlanBean[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public ServicePlanBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ServicePlanBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ServicePlanBean.class, objId);
    }
    ServicePlanBean entity = new ServicePlanBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("planId")) && (!obj.get("planId").isNull())) {
      entity.setPlanId(java_lang_String.demarshall(obj.get("planId"), a1));
    }
    if ((obj.containsKey("version")) && (!obj.get("version").isNull())) {
      entity.setVersion(java_lang_String.demarshall(obj.get("version"), a1));
    }
    return entity;
  }

  public String marshall(ServicePlanBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.services.ServicePlanBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"planId\":").append(java_lang_String.marshall(a0.getPlanId(), a1)).append(",").append("\"version\":").append(java_lang_String.marshall(a0.getVersion(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}