package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.api.beans.services.EndpointType;
import io.apiman.manager.api.beans.services.ServiceBean;
import io.apiman.manager.api.beans.services.ServiceStatus;
import io.apiman.manager.api.beans.services.ServiceVersionBean;
import java.util.Date;
import java.util.Set;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_api_beans_services_ServiceVersionBean_Impl implements GeneratedMarshaller<ServiceVersionBean> {
  private ServiceVersionBean[] EMPTY_ARRAY = new ServiceVersionBean[0];
  private Marshaller<Long> java_lang_Long = Marshalling.getMarshaller(Long.class);
  private Marshaller<ServiceBean> io_apiman_manager_api_beans_services_ServiceBean = null;
  private Marshaller<ServiceStatus> io_apiman_manager_api_beans_services_ServiceStatus = null;
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<EndpointType> io_apiman_manager_api_beans_services_EndpointType = null;
  private Marshaller<Set> java_util_Set = Marshalling.getMarshaller(Set.class);
  private Marshaller<Date> java_util_Date = Marshalling.getMarshaller(Date.class);
  public ServiceVersionBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ServiceVersionBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ServiceVersionBean.class, objId);
    }
    ServiceVersionBean entity = new ServiceVersionBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("id")) && (!obj.get("id").isNull())) {
      entity.setId(java_lang_Long.demarshall(obj.get("id"), a1));
    }
    if ((obj.containsKey("service")) && (!obj.get("service").isNull())) {
      entity.setService(io_apiman_manager_api_beans_services_ServiceBean.demarshall(obj.get("service"), a1));
    }
    if ((obj.containsKey("status")) && (!obj.get("status").isNull())) {
      entity.setStatus(obj.get("status").isObject() != null ? Enum.valueOf(ServiceStatus.class, obj.get("status").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("status").isString() != null ? Enum.valueOf(ServiceStatus.class, obj.get("status").isString().stringValue()) : null);
    }
    if ((obj.containsKey("endpoint")) && (!obj.get("endpoint").isNull())) {
      entity.setEndpoint(java_lang_String.demarshall(obj.get("endpoint"), a1));
    }
    if ((obj.containsKey("endpointType")) && (!obj.get("endpointType").isNull())) {
      entity.setEndpointType(obj.get("endpointType").isObject() != null ? Enum.valueOf(EndpointType.class, obj.get("endpointType").isObject().get("^EnumStringValue").isString().stringValue()) : obj.get("endpointType").isString() != null ? Enum.valueOf(EndpointType.class, obj.get("endpointType").isString().stringValue()) : null);
    }
    if ((obj.containsKey("plans")) && (!obj.get("plans").isNull())) {
      a1.setAssumedElementType("io.apiman.manager.api.beans.services.ServicePlanBean");
      entity.setPlans(java_util_Set.demarshall(obj.get("plans"), a1));
    }
    if ((obj.containsKey("version")) && (!obj.get("version").isNull())) {
      entity.setVersion(java_lang_String.demarshall(obj.get("version"), a1));
    }
    if ((obj.containsKey("createdBy")) && (!obj.get("createdBy").isNull())) {
      entity.setCreatedBy(java_lang_String.demarshall(obj.get("createdBy"), a1));
    }
    if ((obj.containsKey("createdOn")) && (!obj.get("createdOn").isNull())) {
      entity.setCreatedOn(java_util_Date.demarshall(obj.get("createdOn"), a1));
    }
    if ((obj.containsKey("modifiedBy")) && (!obj.get("modifiedBy").isNull())) {
      entity.setModifiedBy(java_lang_String.demarshall(obj.get("modifiedBy"), a1));
    }
    if ((obj.containsKey("modifiedOn")) && (!obj.get("modifiedOn").isNull())) {
      entity.setModifiedOn(java_util_Date.demarshall(obj.get("modifiedOn"), a1));
    }
    if ((obj.containsKey("publishedOn")) && (!obj.get("publishedOn").isNull())) {
      entity.setPublishedOn(java_util_Date.demarshall(obj.get("publishedOn"), a1));
    }
    if ((obj.containsKey("retiredOn")) && (!obj.get("retiredOn").isNull())) {
      entity.setRetiredOn(java_util_Date.demarshall(obj.get("retiredOn"), a1));
    }
    return entity;
  }

  public String marshall(ServiceVersionBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.api.beans.services.ServiceVersionBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"id\":").append(java_lang_Long.marshall(a0.getId(), a1)).append(",").append("\"service\":").append(io_apiman_manager_api_beans_services_ServiceBean.marshall(a0.getService(), a1)).append(",").append("\"status\":").append(a0.getStatus() != null ? new StringBuilder(64).append("{\"^EncodedType\":\"io.apiman.manager.api.beans.services.ServiceStatus\",\"^EnumStringValue\":\"").append(a0.getStatus().name()).append("\"}") : "null").append(",").append("\"endpoint\":").append(java_lang_String.marshall(a0.getEndpoint(), a1)).append(",").append("\"endpointType\":").append(a0.getEndpointType() != null ? new StringBuilder(64).append("{\"^EncodedType\":\"io.apiman.manager.api.beans.services.EndpointType\",\"^EnumStringValue\":\"").append(a0.getEndpointType().name()).append("\"}") : "null").append(",").append("\"plans\":").append(java_util_Set.marshall(a0.getPlans(), a1)).append(",").append("\"version\":").append(java_lang_String.marshall(a0.getVersion(), a1)).append(",").append("\"createdBy\":").append(java_lang_String.marshall(a0.getCreatedBy(), a1)).append(",").append("\"createdOn\":").append(java_util_Date.marshall(a0.getCreatedOn(), a1)).append(",").append("\"modifiedBy\":").append(java_lang_String.marshall(a0.getModifiedBy(), a1)).append(",").append("\"modifiedOn\":").append(java_util_Date.marshall(a0.getModifiedOn(), a1)).append(",").append("\"publishedOn\":").append(java_util_Date.marshall(a0.getPublishedOn(), a1)).append(",").append("\"retiredOn\":").append(java_util_Date.marshall(a0.getRetiredOn(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_manager_api_beans_services_ServiceBean == null) {
      io_apiman_manager_api_beans_services_ServiceBean = Marshalling.getMarshaller(ServiceBean.class);
    }
    if (io_apiman_manager_api_beans_services_ServiceStatus == null) {
      io_apiman_manager_api_beans_services_ServiceStatus = Marshalling.getMarshaller(ServiceStatus.class);
    }
    if (io_apiman_manager_api_beans_services_EndpointType == null) {
      io_apiman_manager_api_beans_services_EndpointType = Marshalling.getMarshaller(EndpointType.class);
    }
  }
}