package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.ui.client.shared.beans.ApiAuthConfigurationBean;
import io.apiman.manager.ui.client.shared.beans.ApiConfigurationBean;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_ui_client_shared_beans_ApiConfigurationBean_Impl implements GeneratedMarshaller<ApiConfigurationBean> {
  private ApiConfigurationBean[] EMPTY_ARRAY = new ApiConfigurationBean[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  private Marshaller<ApiAuthConfigurationBean> io_apiman_manager_ui_client_shared_beans_ApiAuthConfigurationBean = null;
  public ApiConfigurationBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ApiConfigurationBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ApiConfigurationBean.class, objId);
    }
    ApiConfigurationBean entity = new ApiConfigurationBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("endpoint")) && (!obj.get("endpoint").isNull())) {
      entity.setEndpoint(java_lang_String.demarshall(obj.get("endpoint"), a1));
    }
    if ((obj.containsKey("auth")) && (!obj.get("auth").isNull())) {
      entity.setAuth(io_apiman_manager_ui_client_shared_beans_ApiAuthConfigurationBean.demarshall(obj.get("auth"), a1));
    }
    return entity;
  }

  public String marshall(ApiConfigurationBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.ui.client.shared.beans.ApiConfigurationBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"endpoint\":").append(java_lang_String.marshall(a0.getEndpoint(), a1)).append(",").append("\"auth\":").append(io_apiman_manager_ui_client_shared_beans_ApiAuthConfigurationBean.marshall(a0.getAuth(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_manager_ui_client_shared_beans_ApiAuthConfigurationBean == null) {
      io_apiman_manager_ui_client_shared_beans_ApiAuthConfigurationBean = Marshalling.getMarshaller(ApiAuthConfigurationBean.class);
    }
  }
}