package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.ui.client.shared.beans.AppConfigurationBean;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_ui_client_shared_beans_AppConfigurationBean_Impl implements GeneratedMarshaller<AppConfigurationBean> {
  private AppConfigurationBean[] EMPTY_ARRAY = new AppConfigurationBean[0];
  private Marshaller<String> java_lang_String = Marshalling.getMarshaller(String.class);
  public AppConfigurationBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public AppConfigurationBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(AppConfigurationBean.class, objId);
    }
    AppConfigurationBean entity = new AppConfigurationBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("version")) && (!obj.get("version").isNull())) {
      entity.setVersion(java_lang_String.demarshall(obj.get("version"), a1));
    }
    if ((obj.containsKey("builtOn")) && (!obj.get("builtOn").isNull())) {
      entity.setBuiltOn(java_lang_String.demarshall(obj.get("builtOn"), a1));
    }
    if ((obj.containsKey("logoutUrl")) && (!obj.get("logoutUrl").isNull())) {
      entity.setLogoutUrl(java_lang_String.demarshall(obj.get("logoutUrl"), a1));
    }
    if ((obj.containsKey("gatewayBaseUrl")) && (!obj.get("gatewayBaseUrl").isNull())) {
      entity.setGatewayBaseUrl(java_lang_String.demarshall(obj.get("gatewayBaseUrl"), a1));
    }
    return entity;
  }

  public String marshall(AppConfigurationBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.ui.client.shared.beans.AppConfigurationBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"version\":").append(java_lang_String.marshall(a0.getVersion(), a1)).append(",").append("\"builtOn\":").append(java_lang_String.marshall(a0.getBuiltOn(), a1)).append(",").append("\"logoutUrl\":").append(java_lang_String.marshall(a0.getLogoutUrl(), a1)).append(",").append("\"gatewayBaseUrl\":").append(java_lang_String.marshall(a0.getGatewayBaseUrl(), a1)).append("}").toString();
  }

  private void lazyInit() {

  }
}