package org.jboss.errai.marshalling.client.api;

import io.apiman.manager.ui.client.shared.beans.ApiConfigurationBean;
import io.apiman.manager.ui.client.shared.beans.AppConfigurationBean;
import io.apiman.manager.ui.client.shared.beans.ConfigurationBean;
import io.apiman.manager.ui.client.shared.beans.UserConfigurationBean;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jboss.errai.marshalling.client.api.json.EJObject;
import org.jboss.errai.marshalling.client.api.json.EJValue;

public class Marshaller_for_io_apiman_manager_ui_client_shared_beans_ConfigurationBean_Impl implements GeneratedMarshaller<ConfigurationBean> {
  private ConfigurationBean[] EMPTY_ARRAY = new ConfigurationBean[0];
  private Marshaller<AppConfigurationBean> io_apiman_manager_ui_client_shared_beans_AppConfigurationBean = null;
  private Marshaller<UserConfigurationBean> io_apiman_manager_ui_client_shared_beans_UserConfigurationBean = null;
  private Marshaller<ApiConfigurationBean> io_apiman_manager_ui_client_shared_beans_ApiConfigurationBean = null;
  public ConfigurationBean[] getEmptyArray() {
    return EMPTY_ARRAY;
  }

  public ConfigurationBean demarshall(EJValue a0, MarshallingSession a1) {
    lazyInit();
    EJObject obj = a0.isObject();
    if (obj == null) {
      return null;
    }
    String objId = obj.get("^ObjectID").isString().stringValue();
    if (a1.hasObject(objId)) {
      return a1.getObject(ConfigurationBean.class, objId);
    }
    ConfigurationBean entity = new ConfigurationBean();
    a1.recordObject(objId, entity);
    if ((obj.containsKey("apiman")) && (!obj.get("apiman").isNull())) {
      entity.setApiman(io_apiman_manager_ui_client_shared_beans_AppConfigurationBean.demarshall(obj.get("apiman"), a1));
    }
    if ((obj.containsKey("user")) && (!obj.get("user").isNull())) {
      entity.setUser(io_apiman_manager_ui_client_shared_beans_UserConfigurationBean.demarshall(obj.get("user"), a1));
    }
    if ((obj.containsKey("api")) && (!obj.get("api").isNull())) {
      entity.setApi(io_apiman_manager_ui_client_shared_beans_ApiConfigurationBean.demarshall(obj.get("api"), a1));
    }
    return entity;
  }

  public String marshall(ConfigurationBean a0, MarshallingSession a1) {
    lazyInit();
    if (a0 == null) {
      return "null";
    }
    final boolean ref = a1.hasObject(a0);
    final StringBuilder json = new StringBuilder("{\"^EncodedType\":\"io.apiman.manager.ui.client.shared.beans.ConfigurationBean\",\"^ObjectID\"");
    json.append(":\"").append(a1.getObject(a0)).append("\"");
    if (ref) {
      return json.append("}").toString();
    }
    return json.append(",").append("\"apiman\":").append(io_apiman_manager_ui_client_shared_beans_AppConfigurationBean.marshall(a0.getApiman(), a1)).append(",").append("\"user\":").append(io_apiman_manager_ui_client_shared_beans_UserConfigurationBean.marshall(a0.getUser(), a1)).append(",").append("\"api\":").append(io_apiman_manager_ui_client_shared_beans_ApiConfigurationBean.marshall(a0.getApi(), a1)).append("}").toString();
  }

  private void lazyInit() {
    if (io_apiman_manager_ui_client_shared_beans_AppConfigurationBean == null) {
      io_apiman_manager_ui_client_shared_beans_AppConfigurationBean = Marshalling.getMarshaller(AppConfigurationBean.class);
    }
    if (io_apiman_manager_ui_client_shared_beans_UserConfigurationBean == null) {
      io_apiman_manager_ui_client_shared_beans_UserConfigurationBean = Marshalling.getMarshaller(UserConfigurationBean.class);
    }
    if (io_apiman_manager_ui_client_shared_beans_ApiConfigurationBean == null) {
      io_apiman_manager_ui_client_shared_beans_ApiConfigurationBean = Marshalling.getMarshaller(ApiConfigurationBean.class);
    }
  }
}