/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.test.common.util;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import io.apiman.test.common.plan.TestGroupType;
import io.apiman.test.common.plan.TestPlan;
import io.apiman.test.common.plan.TestType;
import io.apiman.test.common.resttest.RestTest;
import io.apiman.test.common.util.TestUtil;
import io.apiman.test.common.util.TestVariableResolver;
import io.apiman.test.common.util.TestVariableResolverFactory;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.NumericNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.TextNode;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.mvel2.MVEL;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class TestPlanRunner {
    private static Logger logger = LoggerFactory.getLogger(TestPlanRunner.class);
    private OkHttpClient client = new OkHttpClient();

    public void runTestPlan(String resourcePath, ClassLoader cl, String baseApiUrl) {
        TestPlan testPlan = TestUtil.loadTestPlan(resourcePath, cl);
        this.log("", new Object[0]);
        this.log("-------------------------------------------------------------------------------", new Object[0]);
        this.log("Executing Test Plan: " + resourcePath, new Object[0]);
        this.log("   Base API URL: " + baseApiUrl, new Object[0]);
        this.log("-------------------------------------------------------------------------------", new Object[0]);
        this.log("", new Object[0]);
        for (TestGroupType group : testPlan.getTestGroup()) {
            this.log("-----------------------------------------------------------", new Object[0]);
            this.log("Starting Test Group [{0}]", group.getName());
            this.log("-----------------------------------------------------------", new Object[0]);
            for (TestType test : group.getTest()) {
                String rtPath = test.getValue();
                this.log("Executing REST Test [{0}] - {1}", test.getName(), rtPath);
                RestTest restTest = TestUtil.loadRestTest(rtPath, cl);
                this.runTest(restTest, baseApiUrl);
                this.log("REST Test Completed", new Object[0]);
                this.log("+++++++++++++++++++", new Object[0]);
            }
            this.log("Test Group [{0}] Completed Successfully", group.getName());
        }
        this.log("", new Object[0]);
        this.log("-------------------------------------------------------------------------------", new Object[0]);
        this.log("Test Plan successfully executed: " + resourcePath, new Object[0]);
        this.log("-------------------------------------------------------------------------------", new Object[0]);
        this.log("", new Object[0]);
    }

    public void runTest(RestTest restTest, String baseApiUrl) throws Error {
        try {
            String requestPath = TestUtil.doPropertyReplacement(restTest.getRequestPath());
            URI uri = this.getUri(baseApiUrl, requestPath);
            String rawType = restTest.getRequestHeaders().get("Content-Type") != null ? restTest.getRequestHeaders().get("Content-Type") : "text/plain; charset=UTF-8";
            MediaType mediaType = MediaType.parse((String)rawType);
            this.log("Sending HTTP request to: " + uri, new Object[0]);
            RequestBody body = null;
            if (restTest.getRequestPayload() != null && !restTest.getRequestPayload().isEmpty()) {
                body = RequestBody.create((MediaType)mediaType, (String)restTest.getRequestPayload());
            }
            Request.Builder requestBuilder = new Request.Builder().url(uri.toString()).method(restTest.getRequestMethod(), body);
            Map<String, String> requestHeaders = restTest.getRequestHeaders();
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                String value = TestUtil.doPropertyReplacement(entry.getValue());
                if (entry.getKey().startsWith("X-RestTest-System-Property")) {
                    String[] split = value.split("=");
                    System.setProperty(split[0], split[1]);
                    continue;
                }
                requestBuilder.addHeader(entry.getKey(), value);
            }
            String authorization = this.createBasicAuthorization(restTest.getUsername(), restTest.getPassword());
            if (authorization != null) {
                requestBuilder.addHeader("Authorization", authorization);
            }
            Response response = this.client.newCall(requestBuilder.build()).execute();
            this.assertResponse(restTest, response);
        }
        catch (Error e) {
            this.logPlain("[ERROR] " + e.getMessage());
            throw e;
        }
        catch (ProtocolException e) {
            this.logPlain("[HTTP PROTOCOL EXCEPTION]" + e.getMessage());
        }
        catch (Exception e) {
            this.logPlain("[EXCEPTION] " + e.getMessage());
            throw new Error(e);
        }
    }

    private String createBasicAuthorization(String username, String password) {
        if (username == null || username.trim().length() == 0) {
            return null;
        }
        username = TestUtil.doPropertyReplacement(username);
        password = TestUtil.doPropertyReplacement(password);
        String val = username + ":" + password;
        return "Basic " + Base64.encodeBase64String((byte[])val.getBytes()).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertResponse(RestTest restTest, Response response) {
        int actualStatusCode = response.code();
        try {
            Assert.assertEquals((String)("Unexpected REST response status code.  Status message: " + response.message()), (long)restTest.getExpectedStatusCode(), (long)actualStatusCode);
        }
        catch (Error e) {
            if (actualStatusCode >= 400) {
                InputStream content = null;
                try {
                    String payload = response.body().string();
                    System.out.println("------ START ERROR PAYLOAD ------");
                    if (payload.startsWith("{")) {
                        payload = payload.replace("\\r\\n", "\r\n").replace("\\t", "\t");
                    }
                    System.out.println(payload);
                    System.out.println("------ END   ERROR PAYLOAD ------");
                }
                catch (Exception e1) {
                }
                finally {
                    IOUtils.closeQuietly(content);
                }
            }
            throw e;
        }
        for (Map.Entry<String, String> entry : restTest.getExpectedResponseHeaders().entrySet()) {
            String expectedHeaderName = entry.getKey();
            if (expectedHeaderName.startsWith("X-RestTest-")) continue;
            String expectedHeaderValue = entry.getValue();
            String header = response.header(expectedHeaderName);
            Assert.assertNotNull((String)("Expected header to exist but was not found: " + expectedHeaderName), (Object)header);
            Assert.assertEquals((Object)expectedHeaderValue, (Object)header);
        }
        String ctValue = response.header("Content-Type");
        if (ctValue == null) {
            this.assertNoPayload(restTest, response);
        } else if (ctValue.startsWith("application/json")) {
            this.assertJsonPayload(restTest, response);
        } else if (ctValue.startsWith("text/plain") || ctValue.startsWith("text/html")) {
            this.assertTextPayload(restTest, response);
        } else if (ctValue.startsWith("application/xml") || ctValue.startsWith("application/wsdl+xml")) {
            this.assertXmlPayload(restTest, response);
        } else {
            Assert.fail((String)("Unsupported response payload type: " + ctValue));
        }
    }

    private void assertNoPayload(RestTest restTest, Response response) {
        String expectedPayload = restTest.getExpectedResponsePayload();
        if (expectedPayload != null && expectedPayload.trim().length() > 0) {
            Assert.fail((String)"Expected a payload but didn't get one.");
        }
    }

    private void assertJsonPayload(RestTest restTest, Response response) {
        InputStream inputStream = null;
        try {
            inputStream = response.body().byteStream();
            ObjectMapper jacksonParser = new ObjectMapper();
            JsonNode actualJson = jacksonParser.readTree(inputStream);
            this.bindVariables(actualJson, restTest);
            String expectedPayload = TestUtil.doPropertyReplacement(restTest.getExpectedResponsePayload());
            Assert.assertNotNull((String)"REST Test missing expected JSON payload.", (Object)expectedPayload);
            JsonNode expectedJson = jacksonParser.readTree(expectedPayload);
            try {
                this.assertJson(restTest, expectedJson, actualJson);
            }
            catch (Error e) {
                System.out.println("--- START FAILED JSON PAYLOAD ---");
                System.out.println(actualJson.toString());
                System.out.println("--- END FAILED JSON PAYLOAD ---");
                throw e;
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void assertXmlPayload(RestTest restTest, Response response) {
        InputStream inputStream = null;
        try {
            inputStream = response.body().byteStream();
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer);
            String xmlPayload = writer.toString();
            String expectedPayload = TestUtil.doPropertyReplacement(restTest.getExpectedResponsePayload());
            Assert.assertNotNull((String)"REST Test missing expected XML payload.", (Object)expectedPayload);
            try {
                XMLUnit.setIgnoreComments((boolean)true);
                XMLUnit.setIgnoreAttributeOrder((boolean)true);
                XMLUnit.setIgnoreWhitespace((boolean)true);
                XMLUnit.setIgnoreDiffBetweenTextAndCDATA((boolean)true);
                Diff diff = new Diff(expectedPayload, xmlPayload);
                diff.overrideDifferenceListener(new DifferenceListener(){

                    public void skippedComparison(Node control, Node test) {
                    }

                    public int differenceFound(Difference difference) {
                        String value = difference.getControlNodeDetail().getValue();
                        if ("*".equals(value)) {
                            return 1;
                        }
                        return 0;
                    }
                });
                XMLAssert.assertXMLEqual(null, (Diff)diff, (boolean)true);
            }
            catch (Error e) {
                System.out.println("--- START FAILED XML PAYLOAD ---");
                System.out.println(xmlPayload);
                System.out.println("--- END FAILED XML PAYLOAD ---");
                throw e;
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void bindVariables(JsonNode actualJson, RestTest restTest) {
        for (String headerName : restTest.getExpectedResponseHeaders().keySet()) {
            if (!headerName.startsWith("X-RestTest-BindTo-")) continue;
            String bindExpression = restTest.getExpectedResponseHeaders().get(headerName);
            String bindVarName = headerName.substring("X-RestTest-BindTo-".length());
            String bindValue = this.evaluate(bindExpression, actualJson);
            this.log("-- Binding value in response --", new Object[0]);
            this.log("\tExpression: " + bindExpression, new Object[0]);
            this.log("\t    To Var: " + bindVarName, new Object[0]);
            this.log("\t New Value: " + bindValue, new Object[0]);
            if (bindValue == null) {
                System.clearProperty(bindVarName);
                continue;
            }
            System.setProperty(bindVarName, bindValue);
        }
    }

    private String evaluate(String bindExpression, JsonNode json) {
        PropertyHandlerFactory.registerPropertyHandler(ObjectNode.class, (PropertyHandler)new PropertyHandler(){

            public Object setProperty(String name, Object contextObj, VariableResolverFactory variableFactory, Object value) {
                throw new RuntimeException("Not supported!");
            }

            public Object getProperty(String name, Object contextObj, VariableResolverFactory variableFactory) {
                ObjectNode node = (ObjectNode)contextObj;
                TestVariableResolver resolver = new TestVariableResolver((JsonNode)node, name);
                return resolver.getValue();
            }
        });
        return String.valueOf(MVEL.eval((String)bindExpression, (VariableResolverFactory)new TestVariableResolverFactory(json)));
    }

    public void assertJson(RestTest restTest, JsonNode expectedJson, JsonNode actualJson) {
        if (expectedJson instanceof ArrayNode) {
            int idx;
            JsonNode actualValue = actualJson;
            ArrayNode expectedArray = (ArrayNode)expectedJson;
            Assert.assertEquals((String)("Expected JSON array but found non-array [" + actualValue.getClass().getSimpleName() + "] instead."), expectedJson.getClass(), actualValue.getClass());
            ArrayNode actualArray = (ArrayNode)actualValue;
            Assert.assertEquals((String)"Array size mismatch.", (long)expectedArray.size(), (long)actualArray.size());
            String ordering = restTest.getExpectedResponseHeaders().get("X-RestTest-ArrayOrdering");
            JsonNode[] expected = new JsonNode[expectedArray.size()];
            JsonNode[] actual = new JsonNode[actualArray.size()];
            for (idx = 0; idx < expected.length; ++idx) {
                expected[idx] = expectedArray.get(idx);
                actual[idx] = actualArray.get(idx);
            }
            if ("any".equals(ordering)) {
                Comparator<JsonNode> comparator = new Comparator<JsonNode>(){

                    @Override
                    public int compare(JsonNode o1, JsonNode o2) {
                        int cmp = o1.toString().compareTo(o2.toString());
                        if (cmp == 0) {
                            cmp = 1;
                        }
                        return cmp;
                    }
                };
                Arrays.sort(expected, comparator);
                Arrays.sort(actual, comparator);
            }
            for (idx = 0; idx < expected.length; ++idx) {
                this.assertJson(restTest, expected[idx], actual[idx]);
            }
        } else {
            Iterator fields = expectedJson.getFields();
            while (fields.hasNext()) {
                JsonNode actualValue;
                Object actual;
                JsonNode actualValue2;
                Object expected;
                Map.Entry entry = (Map.Entry)fields.next();
                String expectedFieldName = (String)entry.getKey();
                JsonNode expectedValue = (JsonNode)entry.getValue();
                if (expectedValue instanceof TextNode) {
                    TextNode tn = (TextNode)expectedValue;
                    expected = tn.getTextValue();
                    actualValue2 = actualJson.get(expectedFieldName);
                    Assert.assertNotNull((String)("Expected JSON text field '" + expectedFieldName + "' with value '" + (String)expected + "' but was not found."), (Object)actualValue2);
                    Assert.assertEquals((String)("Expected JSON text field '" + expectedFieldName + "' with value '" + (String)expected + "' but found non-text [" + actualValue2.getClass().getSimpleName() + "] field with that name instead."), TextNode.class, actualValue2.getClass());
                    actual = ((TextNode)actualValue2).getTextValue();
                    Assert.assertEquals((String)("Value mismatch for text field '" + expectedFieldName + "'."), (Object)expected, (Object)actual);
                    continue;
                }
                if (expectedValue instanceof NumericNode) {
                    NumericNode numeric = (NumericNode)expectedValue;
                    expected = numeric.getNumberValue();
                    actualValue2 = actualJson.get(expectedFieldName);
                    Assert.assertNotNull((String)("Expected JSON numeric field '" + expectedFieldName + "' with value '" + expected + "' but was not found."), (Object)actualValue2);
                    Assert.assertEquals((String)("Expected JSON numeric field '" + expectedFieldName + "' with value '" + expected + "' but found non-numeric [" + actualValue2.getClass().getSimpleName() + "] field with that name instead."), expectedValue.getClass(), actualValue2.getClass());
                    actual = ((NumericNode)actualValue2).getNumberValue();
                    Assert.assertEquals((String)("Value mismatch for numeric field '" + expectedFieldName + "'."), (Object)expected, (Object)actual);
                    continue;
                }
                if (expectedValue instanceof BooleanNode) {
                    BooleanNode bool = (BooleanNode)expectedValue;
                    expected = bool.getBooleanValue();
                    actualValue2 = actualJson.get(expectedFieldName);
                    Assert.assertNotNull((String)("Expected JSON boolean field '" + expectedFieldName + "' with value '" + expected + "' but was not found."), (Object)actualValue2);
                    Assert.assertEquals((String)("Expected JSON boolean field '" + expectedFieldName + "' with value '" + expected + "' but found non-boolean [" + actualValue2.getClass().getSimpleName() + "] field with that name instead."), expectedValue.getClass(), actualValue2.getClass());
                    actual = ((BooleanNode)actualValue2).getBooleanValue();
                    Assert.assertEquals((String)("Value mismatch for boolean field '" + expectedFieldName + "'."), (Object)expected, (Object)actual);
                    continue;
                }
                if (expectedValue instanceof ObjectNode) {
                    actualValue = actualJson.get(expectedFieldName);
                    Assert.assertNotNull((String)("Expected parent JSON field '" + expectedFieldName + "' but was not found."), (Object)actualValue);
                    Assert.assertEquals((String)("Expected parent JSON field '" + expectedFieldName + "' but found field of type '" + actualValue.getClass().getSimpleName() + "'."), ObjectNode.class, actualValue.getClass());
                    this.assertJson(restTest, expectedValue, actualValue);
                    continue;
                }
                if (expectedValue instanceof ArrayNode) {
                    actualValue = actualJson.get(expectedFieldName);
                    Assert.assertNotNull((String)("Expected JSON array field '" + expectedFieldName + "' but was not found."), (Object)actualValue);
                    ArrayNode expectedArray = (ArrayNode)expectedValue;
                    Assert.assertEquals((String)("Expected JSON array field '" + expectedFieldName + "' but found non-array [" + actualValue.getClass().getSimpleName() + "] field with that name instead."), expectedValue.getClass(), actualValue.getClass());
                    ArrayNode actualArray = (ArrayNode)actualValue;
                    Assert.assertEquals((String)("Field '" + expectedFieldName + "' array size mismatch."), (long)expectedArray.size(), (long)actualArray.size());
                    this.assertJson(restTest, (JsonNode)expectedArray, (JsonNode)actualArray);
                    continue;
                }
                if (expectedValue instanceof NullNode) {
                    actualValue = actualJson.get(expectedFieldName);
                    Assert.assertNotNull((String)("Expected Null JSON field '" + expectedFieldName + "' but was not found."), (Object)actualValue);
                    Assert.assertEquals((String)("Expected Null JSON field '" + expectedFieldName + "' but found field of type '" + actualValue.getClass().getSimpleName() + "'."), NullNode.class, actualValue.getClass());
                    continue;
                }
                Assert.fail((String)("Unsupported field type: " + expectedValue.getClass().getSimpleName()));
            }
        }
    }

    private void assertTextPayload(RestTest restTest, Response response) {
        InputStream inputStream = null;
        try {
            inputStream = response.body().byteStream();
            List lines = IOUtils.readLines((InputStream)inputStream);
            StringBuilder builder = new StringBuilder();
            for (String line : lines) {
                builder.append(line).append("\n");
            }
            String actual = builder.toString();
            String expected = restTest.getExpectedResponsePayload();
            if (expected != null) {
                Assert.assertEquals((String)"Response payload (text/plain) mismatch.", (Object)expected, (Object)actual);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public URI getUri(String baseApiUrl, String path) throws URISyntaxException {
        if (baseApiUrl.endsWith("/")) {
            baseApiUrl = baseApiUrl.substring(0, baseApiUrl.length() - 1);
        }
        if (path == null) {
            return new URI(baseApiUrl);
        }
        return new URI(baseApiUrl + path);
    }

    private void log(String message, Object ... params) {
        String outmsg = MessageFormat.format(message, params);
        logger.info("    >> " + outmsg);
    }

    private void logPlain(String message) {
        logger.info("    >> " + message);
    }
}

