/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.test.policies;

import io.apiman.test.policies.PolicyTestRequestType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.map.ObjectMapper;

public class PolicyTestRequest {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final PolicyTestRequestType method;
    private final String resource;
    private Map<String, String> headers = new HashMap<String, String>();
    private String body;

    public static PolicyTestRequest build(PolicyTestRequestType method, String resource) {
        return new PolicyTestRequest(method, resource);
    }

    public PolicyTestRequest(PolicyTestRequestType method, String resource) {
        this.method = method;
        this.resource = resource;
    }

    public PolicyTestRequest header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public PolicyTestRequest basicAuth(String username, String password) {
        return this.header("Authorization", "BASIC " + Base64.encodeBase64String((byte[])(username + ':' + password).getBytes()));
    }

    public PolicyTestRequest body(String body) {
        this.body = body;
        return this;
    }

    public PolicyTestRequest body(Object entity) {
        try {
            String body = mapper.writerWithType(entity.getClass()).writeValueAsString(entity);
            return this.body(body);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PolicyTestRequestType method() {
        return this.method;
    }

    public String resource() {
        return this.resource;
    }

    public String body() {
        return this.body;
    }

    public Map<String, String> headers() {
        return this.headers;
    }
}

