/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.test.policies;

import io.apiman.gateway.engine.IEngine;
import io.apiman.gateway.engine.IEngineResult;
import io.apiman.gateway.engine.IServiceRequestExecutor;
import io.apiman.gateway.engine.async.IAsyncHandler;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.PolicyFailure;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.ServiceResponse;
import io.apiman.gateway.engine.io.IApimanBuffer;
import io.apiman.gateway.engine.io.ISignalWriteStream;
import io.apiman.test.common.io.ByteBuffer;
import io.apiman.test.policies.PolicyFailureError;
import io.apiman.test.policies.PolicyTestRequest;
import io.apiman.test.policies.PolicyTestResponse;
import io.apiman.test.policies.PolicyTester;
import java.util.HashSet;
import org.junit.runner.RunWith;

@RunWith(value=PolicyTester.class)
public abstract class ApimanPolicyTest {
    public static PolicyTester tester;

    public PolicyTestResponse send(final PolicyTestRequest ptRequest) throws PolicyFailureError, Throwable {
        final HashSet errorHolder = new HashSet();
        final HashSet failureHolder = new HashSet();
        final HashSet responseHolder = new HashSet();
        final StringBuilder responseBody = new StringBuilder();
        IEngine engine = tester.getEngine();
        ServiceRequest srequest = tester.createServiceRequest();
        srequest.setDestination(ptRequest.resource());
        srequest.setType(ptRequest.method().name());
        srequest.getHeaders().putAll(ptRequest.headers());
        IServiceRequestExecutor executor = engine.executor(srequest, (IAsyncResultHandler)new IAsyncResultHandler<IEngineResult>(){

            public void handle(IAsyncResult<IEngineResult> result) {
                if (result.isError()) {
                    errorHolder.add(result.getError());
                } else {
                    IEngineResult engineResult = (IEngineResult)result.getResult();
                    if (engineResult.isFailure()) {
                        failureHolder.add(engineResult.getPolicyFailure());
                    } else {
                        responseHolder.add(engineResult.getServiceResponse());
                        engineResult.bodyHandler((IAsyncHandler)new IAsyncHandler<IApimanBuffer>(){

                            public void handle(IApimanBuffer result) {
                                responseBody.append(new String(result.getBytes()));
                            }
                        });
                        engineResult.endHandler((IAsyncHandler)new IAsyncHandler<Void>(){

                            public void handle(Void result) {
                            }
                        });
                    }
                }
            }
        });
        executor.streamHandler((IAsyncHandler)new IAsyncHandler<ISignalWriteStream>(){

            public void handle(ISignalWriteStream stream) {
                if (ptRequest.body() != null) {
                    ByteBuffer buffer = new ByteBuffer(ptRequest.body());
                    stream.write((IApimanBuffer)buffer);
                }
                stream.end();
            }
        });
        executor.execute();
        if (!errorHolder.isEmpty()) {
            throw (Throwable)errorHolder.iterator().next();
        }
        if (!failureHolder.isEmpty()) {
            throw new PolicyFailureError((PolicyFailure)failureHolder.iterator().next());
        }
        if (!responseHolder.isEmpty()) {
            ServiceResponse response = (ServiceResponse)responseHolder.iterator().next();
            return new PolicyTestResponse(response, responseBody.toString());
        }
        throw new Exception("No response found from request!");
    }
}

