/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.test.policies;

import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.ServiceResponse;
import io.apiman.test.common.mock.EchoResponse;
import io.apiman.test.policies.IPolicyTestBackEndService;
import io.apiman.test.policies.PolicyTestBackEndServiceResponse;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class EchoBackEndService
implements IPolicyTestBackEndService {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static long counter = 0L;

    @Override
    public PolicyTestBackEndServiceResponse invoke(ServiceRequest request, byte[] requestBody) {
        try {
            EchoResponse echoResponse = new EchoResponse();
            if (requestBody != null) {
                echoResponse.setBodyLength(new Long(requestBody.length));
                echoResponse.setBodySha1(DigestUtils.sha1Hex((byte[])requestBody));
            }
            echoResponse.setCounter(Long.valueOf(counter++));
            echoResponse.setHeaders(request.getHeaders());
            echoResponse.setMethod(request.getType());
            echoResponse.setResource(request.getDestination());
            echoResponse.setUri("urn:" + request.getDestination());
            ServiceResponse serviceResponse = new ServiceResponse();
            serviceResponse.setCode(200);
            serviceResponse.setMessage("OK");
            serviceResponse.getHeaders().put("Date", new Date().toString());
            serviceResponse.getHeaders().put("Server", "apiman.policy-test");
            serviceResponse.getHeaders().put("Content-Type", "application/json");
            String responseBody = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)echoResponse);
            serviceResponse.getHeaders().put("Content-Length", String.valueOf(responseBody.length()));
            PolicyTestBackEndServiceResponse response = new PolicyTestBackEndServiceResponse(serviceResponse, responseBody);
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

