/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.test.policies;

import io.apiman.common.plugin.Plugin;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.gateway.engine.IComponent;
import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IEngine;
import io.apiman.gateway.engine.IPluginRegistry;
import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Policy;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.components.IBufferFactoryComponent;
import io.apiman.gateway.engine.impl.DefaultComponentRegistry;
import io.apiman.gateway.engine.impl.DefaultEngineFactory;
import io.apiman.gateway.engine.policy.IPolicy;
import io.apiman.test.policies.BackEndService;
import io.apiman.test.policies.Configuration;
import io.apiman.test.policies.EchoBackEndService;
import io.apiman.test.policies.PolicyTesterBufferFactoryComponent;
import io.apiman.test.policies.PolicyTesterConnectorFactory;
import io.apiman.test.policies.TestingPolicy;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Future;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class PolicyTester
extends BlockJUnit4ClassRunner {
    private IEngine engine;
    private String orgId = "PolicyTester";
    private String serviceId = "TestService";
    private int version = 0;

    public PolicyTester(Class<?> testClass) throws InitializationError {
        super(testClass);
        System.out.println("=== Using apiman's PolicyTester on " + testClass);
        this.setTesterOnTest();
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        this.publishService(method);
        super.runChild(method, notifier);
        this.retireService();
    }

    public void run(RunNotifier notifier) {
        this.setEngine(this.createEngine());
        super.run(notifier);
    }

    private void setTesterOnTest() {
        try {
            Field field = this.getTestClass().getJavaClass().getField("tester");
            if (field != null && field.getType().equals(PolicyTester.class)) {
                field.set(null, (Object)this);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    protected void publishService(FrameworkMethod method) {
        ++this.version;
        try {
            TestingPolicy tp = method.getMethod().getAnnotation(TestingPolicy.class);
            if (tp == null) {
                tp = this.getTestClass().getJavaClass().getAnnotation(TestingPolicy.class);
            }
            if (tp == null) {
                throw new Exception("Missing test annotation @TestingPolicy.");
            }
            Class<? extends IPolicy> policyUnderTest = tp.value();
            Configuration config = method.getMethod().getAnnotation(Configuration.class);
            if (config == null) {
                config = this.getTestClass().getJavaClass().getAnnotation(Configuration.class);
            }
            if (config == null) {
                throw new Exception("Missing test annotation @Configuration.");
            }
            BackEndService backEnd = method.getMethod().getAnnotation(BackEndService.class);
            if (backEnd == null) {
                backEnd = this.getTestClass().getJavaClass().getAnnotation(BackEndService.class);
            }
            Class backEndService = null;
            backEndService = backEnd == null ? EchoBackEndService.class : backEnd.value();
            final HashSet errorHolder = new HashSet();
            Policy policy = new Policy();
            policy.setPolicyImpl("class:" + policyUnderTest.getName());
            policy.setPolicyJsonConfig(config.value());
            Service service = new Service();
            service.setEndpoint(backEndService.getName());
            service.setEndpointType("TEST");
            service.setOrganizationId(this.orgId);
            service.setServiceId(this.serviceId);
            service.setVersion(String.valueOf(this.version));
            service.setPublicService(true);
            service.setServicePolicies(Collections.singletonList(policy));
            this.getEngine().getRegistry().publishService(service, (IAsyncResultHandler)new IAsyncResultHandler<Void>(){

                public void handle(IAsyncResult<Void> result) {
                    if (result.isError()) {
                        errorHolder.add(result.getError());
                    }
                }
            });
            if (!errorHolder.isEmpty()) {
                throw (Throwable)errorHolder.iterator().next();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void retireService() {
        Service service = new Service();
        service.setOrganizationId(this.orgId);
        service.setServiceId(this.serviceId);
        service.setVersion(String.valueOf(this.version));
        this.getEngine().getRegistry().retireService(service, (IAsyncResultHandler)new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
            }
        });
    }

    private IEngine createEngine() {
        DefaultEngineFactory factory = new DefaultEngineFactory(){

            protected IConnectorFactory createConnectorFactory(IPluginRegistry pluginRegistry) {
                return new PolicyTesterConnectorFactory();
            }

            protected IComponentRegistry createComponentRegistry(IPluginRegistry pluginRegistry) {
                return new DefaultComponentRegistry(){

                    protected void registerBufferFactoryComponent() {
                        this.addComponent(IBufferFactoryComponent.class, (IComponent)new PolicyTesterBufferFactoryComponent());
                    }
                };
            }

            protected IPluginRegistry createPluginRegistry() {
                return new IPluginRegistry(){

                    public Future<IAsyncResult<Plugin>> loadPlugin(PluginCoordinates coordinates, IAsyncResultHandler<Plugin> handler) {
                        throw new RuntimeException("Plugins not supported.");
                    }
                };
            }
        };
        return factory.createEngine();
    }

    public IEngine getEngine() {
        return this.engine;
    }

    private void setEngine(IEngine engine) {
        this.engine = engine;
    }

    public ServiceRequest createServiceRequest() {
        ServiceRequest request = new ServiceRequest();
        request.setServiceOrgId(this.orgId);
        request.setServiceId(this.serviceId);
        request.setServiceVersion(String.valueOf(this.version));
        request.setTransportSecure(true);
        return request;
    }
}

